/**
 * CameraXBeeWifi program.
 *
 * CameraC328Library
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 *
 * CameraC1098-SS Library
 * Copyright (C) 2012 Tadao Iida
 */

#include "mbed.h"
#include "CameraC1098.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);

CameraC1098 camera(p9, p10);

Serial xbeewifi(p13,p14);

/**
 * A callback function for jpeg images.
 * You can block this function until saving the image datas.
 *
 * @param buf A pointer to the image buffer.
 * @param siz A size of the image buffer.
 */
void jpeg_callback(char *buf, size_t siz) {
    
    for (int i = 0; i < (int)siz; i++) {
        xbeewifi.putc(buf[i]) ;
    }
    
}

void sync(void) {
    CameraC1098::ErrorNumber err = CameraC1098::NoError;

    err = camera.sync();
    lcd.locate(0,0);
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::sync\r\n");
        lcd.printf("Camera Sync [OK]");
    } else {
        printf("[FAIL] : CameraC1098::sync (Error=%02X)\r\n", (int)err);
        lcd.printf("Camera init [NG]");
    }
}

void test_jpeg_snapshot_picture(void) {
    CameraC1098::ErrorNumber err = CameraC1098::NoError; 
    
    err = camera.getJpegSnapshotPicture(jpeg_callback);

    lcd.locate(0,0);        
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::getJpegSnapshotPicture\r\n");
        lcd.printf("Camera send [OK]");
    } else {
        printf("[FAIL] : CameraC1098::getJpegSnapshotPicture (Error=%02X)\r\n", (int)err);
        lcd.printf("Camera send [NG]");
    }
}

int main() {

    wait(2.0) ;
   
    printf("\r\n");
    printf("==========\r\n"); 
    printf("CameraC1098\r\n");
    printf("==========\r\n");
    CameraC1098::ErrorNumber err = CameraC1098::NoError;
    
    err = camera.init(CameraC1098::Baud230400, CameraC1098::JpegResolution320x240);
    
    camera.setmbedBaud( CameraC1098::Baud230400 );
    
    xbeewifi.baud(230400);
        
    lcd.locate(0,0);    
    
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::init\r\n") ;
        lcd.printf("Camera init [OK]");
    } else {
        printf("[FAIL] : CameraC1098::init (Error=%02X)\r\n", (int)err) ;
        lcd.printf("Camera init [NG]");
        exit(-1);
    }
         
    sync();     
     
    while(1){    
        lcd.locate(0,1);
        lcd.printf("pictshort       ");
        test_jpeg_snapshot_picture();
     }                
}