#include "mbed.h"
#include "TextLCD.h"

#define U_THR 0.65
#define D_THR 0.2
#define L_THR 0.2
#define R_THR 0.65
#define H_THR 0.6
#define CH_THR 0.6

#define HEADER 2
#define CHA_INTERVAL1 130 // 130
#define CHA_INTERVAL2 10  // 10
#define CHB_INTERVAL1 110 // 130
#define CHB_INTERVAL2 30  // 10
#define CHC_INTERVAL1 90 // 130
#define CHC_INTERVAL2 50  // 10
#define CHD_INTERVAL1 70  // 130
#define CHD_INTERVAL2 70  // 10

typedef enum { OFF, ON } state;

TextLCD lcd(p24, p26, p27, p28, p29, p30);
PwmOut out(p21);
AnalogIn lr_in(p18); // Joystick Left,Right -> Left+Right 
AnalogIn ud_in(p19); // Joystick Up,Down -> Forward+Backward 
AnalogIn hs_in(p20); // PSW hs -> Dash!
AnalogIn ch_in(p17); // PSW ch -> Change CH A,B,C,D

typedef void (*FUNCPTR)();
FUNCPTR pFuncBand;
// Remote Control Signal ON
void on(){
    int begin;
    Timer ton;
    ton.start();
    begin = ton.read_us();
    while ( 500 > ton.read_us() - begin )
        out.write(0.0f) ;
    begin = ton.read_us();  
    while ( 1000 > ton.read_us() - begin )
        out.write(0.5f) ;
    ton.stop();
}

// Remote Control Signal OFF
void off(){
    int begin;
    Timer toff;
    toff.start();
    begin = toff.read_us();
    while( 500 > toff.read_us() - begin )
        out.write(0.0f) ;
   
    begin = toff.read_us();
    while ( 500 > toff.read_us() - begin )
        out.write(0.5f) ;
    toff.stop() ;    
}

int flag=0;
void tail()
{
    out.write(0.0f) ; 
    flag = 0;
}

void bandA(){
    off();off();
}
void bandB(){
    off();on();    
}
void bandC(){
    on();off();    
}
void bandD(){
    on();on();  
}       

Ticker in;
Timer timer;
float lr, ud, hs ;
volatile float ch;
int interval1, interval2;

// Joystick Sensor
void input()
{
    lr = lr_in;
    ud = ud_in;
    hs = hs_in; 
    ch = ch_in ;       
}

volatile int psw = 0;

void interval(int iTime,state s){
    float signal;
    int t;
    signal = (s==OFF)? 0.0f : 0.5f; 
    timer.start();
    t = timer.read_ms();
    while ( iTime > timer.read_ms() - t )
        out.write(signal) ;
    timer.stop();                        
}

int main() {
    in.attach(&input, 0.05);

    out.period_us(26);
    lcd.cls() ;
    lcd.locate(1,1);
    lcd.printf("BAND [A]");
    interval1 = CHA_INTERVAL1;
    interval2 = CHA_INTERVAL2;
    (pFuncBand) = &bandA;

    while(1) {
        // #DEBUG printf("UD%4.2f HS%4.2f ",ud,hs);
        // #DEBUG printf("\tLR%4.2f CH%1d %4.2f \r\n",lr,psw,ch);
        if( ch >= CH_THR ){
            while(1){  
                if(ch < 0.2 ){   
                    if ( psw < 3 ){
                        psw++;
                    }else{ 
                        psw=0;
                    }    
                    break;
                }
            }
            
            lcd.locate(1,1);
            
            
            if(psw == 0 ){
                lcd.printf("BAND [A]"); printf("banda\r\n");
                (pFuncBand) = &bandA;
                interval1 = CHA_INTERVAL1;
                interval2 = CHA_INTERVAL2;        
            }else if(psw == 1){
                lcd.printf("BAND [B]");
                (pFuncBand) = &bandB;
                interval1 = CHB_INTERVAL1;
                interval2 = CHB_INTERVAL2;        
            }else if(psw == 2){;
                lcd.printf("BAND [C]");
                pFuncBand = &bandC;
                interval1 = CHC_INTERVAL1;
                interval2 = CHC_INTERVAL2;        
            }else{
                lcd.printf("BAND [D]"); printf("band D\r\n");
                pFuncBand = &bandD;
                interval1 = CHD_INTERVAL1;
                interval2 = CHD_INTERVAL2;
            }              
        }
        lcd.locate(0,0);
        if ( (U_THR < ud && H_THR < hs) && (L_THR < lr && lr < R_THR)){
            // Forward + Dash!(0101)
            lcd.printf("Forward+Dash!   ");
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)();   
            off(); on(); off();on(); 
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();     
            off(); on(); off(); on();
            tail();
        }else if((ud < D_THR && H_THR < hs) && (L_THR < lr && lr < R_THR)){
            // Backward + Dash!(1100)
            lcd.printf("Backward+Dash!  ");            
            interval(interval1,OFF); // chA Interval1
            interval(HEADER,ON); //HEADER 
            (pFuncBand)();
            on(); on(); off();off(); // Control Code 1100
            interval(interval2,OFF); // chA Interval2 
            interval(HEADER,ON); // HEADER
            (pFuncBand)();
            on(); on(); off(); off(); // Control Code 1100               
            tail();  
        }else if ((U_THR < ud && H_THR < hs) && (lr < L_THR)){
            // Forward + Left + Dash!
            lcd.printf("For+Left+Dash!  ");            
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)();      
            on(); off(); off(); off(); 
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();    
            on(); off(); off(); off();              
            tail();        
        }else if((U_THR < ud && H_THR < hs) && (R_THR < lr)){
            // Forward + Right + Dash!;
            lcd.printf("For+Right+Dash! ");            
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)();    
            on(); off(); off(); on(); 
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();    
            on(); off(); off(); on();
            tail();                       
        }else if((ud < D_THR && H_THR < hs) && (lr < L_THR)){
            // Backward + Left + Dash!
            lcd.printf("Back+Left+Dash! ");            
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)();      
            on(); on(); off(); on(); 
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();   
            on(); on(); off(); on();            
            tail();
        }else if((ud < D_THR && H_THR < hs) && (R_THR < lr)){
            // Backward + Right + Dash!
            lcd.printf("Back+Right+Dash!");            
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)();    
            on(); on(); on(); off(); 
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();    
            on(); on(); on(); off();            
            tail();
        }else if ( U_THR < ud && lr < L_THR ){
            // Forward + Left
            lcd.printf("Forward+Left    ");
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)();  
            off(); on(); on(); off();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();    
            off(); on(); on(); off();            
            tail();
        }else if( U_THR < ud && R_THR < lr){
            // Forward + Right
            lcd.printf("Forward+Right   ");
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)(); 
            off(); on(); on(); on();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();   
            off(); on(); on(); on();
            tail();                                  
        }else if( ud < D_THR && lr < L_THR){
            // Backward+Left(1010)
            lcd.printf("Backward+Left   ");
            (pFuncBand)();
            interval(HEADER,ON);
            (pFuncBand)();    
            on(); off(); on(); off();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();     
            on(); off(); on(); off();
            tail();                      
        }else if (ud < D_THR && R_THR < lr){
            // Backward + Right (1011)
            lcd.printf("Backward+Right  ");
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)(); 
            on(); off(); on(); on();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();  
            on(); off(); on(); on(); 
            tail();                    
        }else if((U_THR <= ud)&&(L_THR < lr && lr < R_THR)){
            // Forward(0001)
            lcd.printf("Forward         ");            
            interval(interval1,OFF);    
            interval(HEADER,ON);
            (pFuncBand)();   
            off();off();off();on();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();     
            off();off();off();on();            
            tail();
        }else if((ud <= D_THR)&&(L_THR < lr && lr < R_THR)){
            // Backward(0010)
            lcd.printf("Backward        ");
            interval(interval1,OFF);   
            interval(HEADER,ON);
            (pFuncBand)();   
            off();off();on();off();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();     
            off();off();on();off();
            tail();                              
        }else if(lr < L_THR && (D_THR <= ud && ud <= U_THR)){
            // Left(0011)
            lcd.printf("Left <=          ");            
            interval(interval1,OFF);      
            interval(HEADER,ON);
            (pFuncBand)();  
            off();off();on();on();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();
            off();off();on();on(); 
            tail();                      
        }else if(R_THR < lr && (D_THR <= ud && ud <= U_THR)){
            // Right(0100)
            lcd.printf("Right =>        ");            
            interval(interval1,OFF);      
            interval(HEADER,ON);
            (pFuncBand)();
            off();on();off();off();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();
            off();on();off();off();
            tail();            
        }else if((D_THR <= ud && ud <= U_THR) && (L_THR < lr && lr < R_THR)){
            if ( flag == 0 ){
                for ( int i = 0; i < 5 ; i++ ){
                    // STOP(1111);
                    lcd.locate(0,0);
                    lcd.printf("Stop            ");            
                    interval(interval1,OFF);      
                    interval(HEADER,ON);
                    (pFuncBand)();   
                    on();on();on();on();
                    interval(interval2,OFF);
                    interval(HEADER,ON);
                    (pFuncBand)();
                    on();on();on();on();
                }
                flag = 1;
            }else{
                out.write(0.0f) ;
                lcd.locate(0,0);
                lcd.printf("                ");    
            }                       
        }            
    }        
}
