#include "mbed.h"

#define numsamples 1
int touchSense1(void);  //function for the button 1

DigitalOut myled1(LED1);
AnalogIn input1(p20);
DigitalIn charger1(p19);
DigitalOut ground1(p18);
Serial pc(USBTX, USBRX); // tx, rx

int touchSense2(void);  //function for the button 2

DigitalOut myled2(LED4);
AnalogIn input2(p15);
DigitalIn charger2(p16);
DigitalOut ground2(p17);

int getc();
void setcode();
     

char incode[10];
char strcode[10];
char matcode[10];
char temp;
int codelen = 1;
int matlen;
int i=0;
int j=0;
int flag1 = 0;
int flag2 = 0;
int failflag = 0;

int main() {

  for (i=0;i<10;i++){   //initial the char array
    incode[i] = 'a';    
    strcode[i] = 'a';
  }

  pc.attach(&setcode, Serial::RxIrq);

  while(1) {
    
    
   if (touchSense1()) { 
       wait (0.005);    //wait 5ms for checking press
       if (touchSense1()){
            myled1 = 1;
            if (flag1 == 0){
                flag1 =1;   //flag1 for symbol press
                pc.printf("1");
                matcode[matlen] = '1'; //record for compare
                matlen ++;
             }
        }
         
    } else {
        wait(0.005);  //wait 5ms confirm release
        if (touchSense1()==0){
            myled1 = 0;
            flag1 = 0; //clear flag
        }
    }
    
 
    if (touchSense2()) { //samiliar as above 1
       wait (0.005);
       if (touchSense2()){
            myled2 = 1;
            if (flag2 == 0){
                flag2 =1;
                pc.printf("0");
                matcode[matlen] = '0';
                matlen ++;
             }
        }
         
    } else {
        wait(0.005);
        if (touchSense2()==0){
            myled2 = 0;
            flag2 = 0;
        }
    }
    
    if (flag1 == 1 && flag2 == 1){ //detect press both button
        pc.printf("\nError, please don't touch both!!");
        //break;
    }
    
    if (matlen >= codelen){ //check input length match the set up
        for (i=0;i<codelen;i++){
            if (matcode[i] != strcode[i])
                failflag = 1; //flag for symbol not match
        }
        
        if (failflag == 0){
            pc.printf("\n Congratulations! Code is matched!!\n");
            matlen = 0;
            
        }
        
        else{
            pc.printf("\nSorry, the code is wrong, please input again!!\n");
            failflag = 0;
            matlen = 0;
        }
        
    }
    
   
  }
}

int touchSense1(void) //function for touch sensor
{
    float sample;
    ground1 = 0;
    charger1.mode(PullUp);
    charger1.mode(PullNone);
    sample=input1.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}
int touchSense2(void)
{
    float sample;
    ground2 = 0;
    charger2.mode(PullUp);
    charger2.mode(PullNone);
    sample=input2.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

void setcode(){
  i=0;
  j=0;
  pc.printf("\nPlease inpunt the code:\n");
  while ((temp = pc.getc())!= 'E') {    //getchar
    pc.printf("%c",temp);
    incode[i] = temp;    //put the original char in incode      
    i++;
  }    
  
  incode[i] = 'E'; //put "E" last as the end symbol
  pc.printf("%c",temp);
  pc.printf("\nThanks for the string, your input is\n");
  
  for (i=0;i<10;i++){   //extract 0/1 from incode to strcode
    if (incode[i] == 'E')
        break;
    else{
        if (incode[i] == '0' || incode[i] == '1'){
            strcode[j] = incode[i];
            j++;
        }
    }
        
  }
  
  codelen = j;
  
  for (j=0;j<codelen;j++)   //display the configuration
    pc.printf("%c",strcode[j]);
  pc.printf("\n");
  
  matlen = 0;  
  
  pc.printf("\nPlease input the code:");
}