#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
Serial ss(p9, p10); //tx rx
Serial ss_sne(p13, p14); //tx rx

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

DigitalOut masterOut(p23);
InterruptIn masterIn(p22);
InterruptIn slaveIn(p21);

unsigned long counter = 0;
int divider = 1;
int pro_flag = 0;  
int task_flag = 0;
unsigned long long t1, t2, t3, t4;
typedef struct timeval {
    unsigned long tv_sec;
    unsigned long tv_usec;
} timeval;
//struct timeval capture_t;

void Timer0_init(void);
void Timer0_IRQHandler(void);
void Sync_protocol(void);
void getTime(struct timeval *tv);
int runAtTime (void (*fptr)(void), struct timeval tv);
void toggle(void);
void runAtTrigger( );
void reportToggle(struct timeval *tv);
long long sne(void);

int main( )
{   
    struct timeval t_run;
//    t_run.tv_sec = 1000;
//    t_run.tv_usec = 0;
    long long t_run_m;
    long long  i = 61;
//    wait(1);
//    masterIn.rise(&runAtTrigger);
//    masterIn.fall(&runAtTrigger);
    slaveIn.rise(&runAtTrigger);
    slaveIn.fall(&runAtTrigger);
    Timer0_init( );
    t_run_m = i*1000000;
    ss_sne.printf("%llu", t_run_m);
    ss_sne.putc('E');
    t_run.tv_sec = t_run_m/1000000;
    t_run.tv_usec = t_run_m%1000000;
//    pc.printf("s%lu ",t_run.tv_sec);
//    pc.printf("%lu\n",t_run.tv_usec);
    while (1)
    {   
        if (!task_flag)
            task_flag = runAtTime (&toggle, t_run);
        else if (task_flag && i < 25000){
            i++;
            t_run_m = i*1000000;
            ss_sne.printf("%llu", t_run_m);
            ss_sne.putc('E');
            t_run.tv_sec = t_run_m/1000000;
            t_run.tv_usec = t_run_m%1000000;
            //pc.printf("s%lu ",t_run.tv_sec);
            //pc.printf("%lu\n",t_run.tv_usec);
            task_flag = 0;
        }    
        if (pro_flag == 1){
            Sync_protocol( );
            pro_flag = 0;
        }   
    }
}

void Timer0_init(void)
{
    LPC_SC->PCLKSEL0 = 0x0066;
    LPC_SC->PCONP |= 1<<1; // Timer0 Power On
    LPC_TIM0->MR0 = 2880000000;  // Match count for 30S
    LPC_TIM0->MCR = 3;     // Interrupt and Reset on Match
    LPC_TIM0->TCR = 1;     // Enable Timer0  
    NVIC_SetVector (TIMER0_IRQn, (uint32_t)&Timer0_IRQHandler);
    NVIC_EnableIRQ(TIMER0_IRQn);
}

void Timer0_IRQHandler(void)
{
    LPC_TIM0->IR = 1;
    LPC_TIM0->MR0 = 2880000000;  // Match count for 30S
    LPC_TIM0->TCR = 1;     // Enable Timer0
    counter = counter + 1;
    if ( counter % divider ==0 )
        pro_flag = 1;
}

void Sync_protocol(void)
{   
    char x;
    t1 = counter * 4294967296 + LPC_TIM0->TC;
    ss.putc('S');
//    pc.printf("t1 = %llu\n", t1);
    ss.printf("%llu", t1);
    ss.putc('E');
    while (1){
        if (ss.readable( )){
            x = ss.getc( );
            t4 = counter * 4294967296 + LPC_TIM0->TC;
            ss.printf("%llu", t4);
            ss.putc('E');
//            pc.printf("%c\n", x);
//            pc.printf("t4 = %llu\n", t4);
            break;
        }
    }    
}

void getTime(struct timeval *tv){
    unsigned long ns, hs;
    ns = LPC_TIM0->TC;
    hs = counter;
    tv->tv_sec = hs*30 + ns/100000000;
    tv->tv_usec = (ns%100000000)/100;
}

int runAtTime (void (*fptr)(void), struct timeval tv){
      struct timeval current_t;
      getTime(&current_t);
      if (tv.tv_sec <= current_t.tv_sec && tv.tv_usec <= current_t.tv_usec){
          (*fptr) ( );
//          capture_t=current_t;
          return 1;
      }
      else 
          return 0;  
}

void toggle(void){
    masterOut = !masterOut;
}

void runAtTrigger(void){
   struct timeval response_t;
   reportToggle(&response_t);  
}

void reportToggle(struct timeval *tv)
{
    getTime(tv);
//    pc.printf("r %u ", capture_t.tv_sec);
//    pc.printf("%u\n", capture_t.tv_usec);
    pc.printf("r %u ", tv->tv_sec);
    pc.printf("%u\n", tv->tv_usec);
    myled2 = !myled2;   
}

long long sne( ){
    char temp;
    char incode[100];
    int i=0;
    int j=0;
    long long sum = 0;
    while ((temp = pc.getc())!= 'E') {    //getchar
        incode[i] = temp;    //put the original char in incode      
        i++;
    } 
    for (j=1;j<i;j++){
        sum = (incode[j]-'0')+sum*10;
    }
    if (incode[0]=='S'){
        ss_sne.printf("%llu", sum);
        ss_sne.putc('E');
        return sum;
    }
    else
        return 0;
}