#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
Serial ss(p9, p10); //tx rx
Serial ss_sne(p13, p14);
DigitalOut myled(LED3);
DigitalOut rst1(p11);
DigitalOut slaveOut(p23);


void Timer0_init(void);
void Timer0_IRQHandler(void);
void slavesyn(void);
void backtime(void);
long long assembletime(long long t);
int runAtTime (void (*fptr)(void), struct timeval tv);
void getTime(struct timeval *tv);
void toggle(void);

long counter = 0;
int divider = 4;  
long long t1;
long long  t2, t3, t4, t5, t6;
long long delay;
long long offdri;
char test;
long long receive(void);
long long receive_sne(void);
long long snesig;
long long sne(void);
int task_flag = 0;

typedef struct timeval {
    unsigned long tv_sec;
    unsigned long tv_usec;
} timeval;

struct timeval t_run;
struct timeval t_run2;

int main( )
{   
    pc.printf("\nbegin\n");
    Timer0_init( );
    t_run.tv_sec = 1000;
    t_run.tv_usec = 0;
 
    t_run2.tv_sec = 1000;
    t_run2.tv_usec = 0;
        
    while (1)
    {
        myled = 0;
        t2 = 100000000000000000;
        if (!task_flag){
            task_flag = runAtTime (&toggle, t_run2);
        }
        
        if (ss_sne.readable()){
            snesig = receive_sne();
            t_run.tv_sec = snesig/1000000;
            t_run.tv_usec = snesig%1000000;
            pc.printf("\nSNE is %llu\n",snesig);
            pc.printf("\ntv_sec = %u, tv_usec = %u\n",t_run.tv_sec,t_run.tv_usec);
            task_flag = 0;
        }
           
        if (ss.readable( )){
            myled = 1;
            test = ss.getc();
            pc.printf("%d\n", test-'S');

            if (test == 'S' ){
                slavesyn();
                
            }
            else{
                if (test == 'T'){
                    backtime();
                }
                else{
                    pc.printf("\nSystem Error--1!!\n");
                }            
            }  
        }
    }
}

void Timer0_init(void)
{
    LPC_SC->PCLKSEL0 = 0x0066;
    LPC_TIM0->MR0 = 2880000000;  // Match count for 100uS
    LPC_TIM0->MCR = 3;     // Interrupt and Reset on Match
    LPC_TIM0->TCR = 1;     // Enable Timer0  
    NVIC_SetVector (TIMER0_IRQn, (uint32_t)&Timer0_IRQHandler);
    NVIC_EnableIRQ(TIMER0_IRQn);
}



void Timer0_IRQHandler(void)
{
    LPC_TIM0->IR = 1;
    LPC_TIM0->MR0 = 2880000000;  // Match count for 100uS
    LPC_TIM0->TCR = 1;     // Enable Timer0
    counter = counter + 1;
}

void slavesyn(void)
{
    pc.printf("in to fuc\n");
        t2 = counter * 4294967296 + LPC_TIM0->TC;
        pc.printf("t2 = %llu\n",t2);
       
        t1 = receive();
        pc.printf("t1 = %llu\n",t1);
        
        wait(0.1);
        t3 = counter * 4294967296 + LPC_TIM0->TC;
        ss.putc('S');        
        pc.printf("t3 = %llu\n", t3);

        t4 = receive();
        pc.printf("t4 = %llu\n",t4);
        
        
        t1 = assembletime(t1);
        t2 = assembletime(t2);
        t3 = assembletime(t3);
        t4 = assembletime(t4);
        
      //  pc.printf("t2-t1 = %ll\n t1-t2 = %ll \n", (lld)t2-t1,(lld)t1-t2);
        
       /* 
        offdri = (t2/4294967296 - t1/4294967296) *30*1000000000 +  (t2%4294967296 - t1%4294967296);
        pc.printf("offderi = %llu\n",offdri);
        
        delay = (t4/4294967296 - t3/4294967296) *4294967296 +  (t4%4294967296 - t3%4294967296);
        pc.printf("delay = %llu\n",delay);
*/

        
        //assume t2>t1 since slave reset first
        if(t3>t4){
            if ((t2-t1)>(t3-t4)){
                delay = ((t2-t1)-(t3-t4))/2;
                offdri = ((t2-t1)+(t3-t4))/2;   
            }
            else{
                delay = ((t3-t4)-(t2-t1))/2;
                offdri = ((t2-t1)+(t3-t4))/2;
            }
        }
        else{ //t4>t3
            if ((t2-t1)<(t4-t3)){
                delay = ((t2-t1)+(t4-t3))/2;
                offdri = ((t4-t3)-(t2-t1))/2;
            }
            else{
                delay = ((t2-t1)+(t4-t3))/2;
                offdri = ((t2-t1)-(t4-t3))/2;
            }
        } 
        t_run2.tv_sec = t_run.tv_sec + offdri/1000000000;
        t_run2.tv_usec = t_run.tv_usec + (offdri%1000000000)/1000; 
        pc.printf("\nt2v_sec = %u, t2v_usec = %u\n",t_run2.tv_sec,t_run2.tv_usec);                
        pc.printf("Delay = %llu\n",delay);
        pc.printf("offderi = %llu\n",offdri);

        
}

long long receive(void){
    char x;
    long long y;
    
    y=0;
    while(1){
            if(ss.readable()){
                x = ss.getc();
                if(x == 'E'){
                    return y;
                }
                else{
                    y = y*10 + (int)(x-48);
                }
            }
    }
}

long long assembletime(long long t){
    long long temp;

    temp = (t/4294967296)*30*1000000000 + (t%4294967296)*10;
    return temp;
}

void backtime(){
    long long t;
    long long temp;
    t = counter * 4294967296 + LPC_TIM0->TC;
    t = assembletime(t);
    t = t - offdri + delay;
    /*
    temp = t/30/1000000000;
    t = (t%30000000000)/10 + temp*4294967296;
    */
    ss.printf("%llu",t);
    ss.putc('E');
}

void toggle(){
    slaveOut = !slaveOut;
}

long long receive_sne(void){
    char x;
    long long y;
    
    y=0;
    while(1){
            if(ss_sne.readable()){
                x = ss_sne.getc();
                if(x == 'E'){
                    return y;
                }
                else{
                    y = y*10 + (int)(x-48);
                }
            }
    }
}

void getTime(struct timeval *tv){
    unsigned long ns, hs;
    ns = LPC_TIM0->TC;
    hs = counter;
    tv->tv_sec = hs*30 + ns/100000000;
    tv->tv_usec = (ns%100000000)/100;
}

int runAtTime (void (*fptr)(void), struct timeval tv){
      struct timeval current_t;
      getTime(&current_t);
      if (tv.tv_sec <= current_t.tv_sec && tv.tv_usec <= current_t.tv_usec){
          (*fptr) ( );
          return 1;
      }
      else 
          return 0;  
}

