// #include "mbed.h"
#include "device.h"
#include "PinNames.h"
#include "PeripheralNames.h"
#include "i2c_api.h"
#include "wait_api.h"
#include "pwmout_api.h"
#include "rtc_api.h"
#include <stdio.h>
#include <math.h>

#define REG_WHO_AM_I      0x0D
#define REG_CTRL_REG_1    0x2A
#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05

#define MMA8451_I2C_ADDRESS (0x1d<<1)

#define UINT14_MAX        16384

#define false 0
#define true -1

static const float redx=0.0f;
static const float redy=1.0f;
static const float greenx=0.8660254f;
static const float greeny=-0.5f;
static const float bluex=-0.8660254f;
static const float bluey=-0.5f;

static const float twothirds=0.6666667f;

void acclninit(i2c_t *i2c)
{
  // set the i2c link pins SDA, SCL
  i2c_init(i2c,PTE25,PTE24);

  // initialise the accelerometer
  {
    // REG_CTRL_REG_1 goes into the device Program Counter
    // then 1 gets written to that address
    uint8_t data[2] = {REG_CTRL_REG_1, 0x01};
    i2c_write(i2c,MMA8451_I2C_ADDRESS,(char *)data,2,true);
  }
  
  // read the who am i register
  {
    // this sets the pointer in the I2C decice (accelerometer)
    // to point to the who_am_i register
    // REG_WHO_AM_I gets writtem to device Program Counter
    // We don't reset the device at the end (false)
    char t[1] = {REG_WHO_AM_I};
    i2c_write(i2c,MMA8451_I2C_ADDRESS,t,1,false);
    // and this reads the register
    uint8_t who_am_i = 0;
    i2c_read(i2c,MMA8451_I2C_ADDRESS,(char *)&who_am_i,1,true);
    printf("\r\nMMA8451 ID: %d\r\n", who_am_i );
  }
}  

float acclnread(i2c_t *i2c,uint8_t reg)
{
  char t[1]= {reg};
  i2c_write(i2c,MMA8451_I2C_ADDRESS,t,1,false);
  uint8_t xbits[2] = {0,0};
  i2c_read(i2c,MMA8451_I2C_ADDRESS,(char *)xbits,2,true);
  int16_t xint = 0;
  xint=(xbits[0]<<6)|(xbits[1]>>2);
  if (xint > UINT14_MAX>>1)
    xint -= UINT14_MAX;
  return ((float) xint)/4096.0f;
}



int main(void)
{
  //  typedef struct i2c_s i2c;
  i2c_t i2c;

  acclninit(&i2c);

  pwmout_t redled;
  pwmout_t greenled;
  pwmout_t blueled;

  pwmout_init(&redled,LED_RED);
  pwmout_period_ms(&redled,1);
  pwmout_init(&greenled,LED_GREEN);
  pwmout_period_ms(&greenled,1);
  pwmout_init(&blueled,LED_BLUE);
  pwmout_period_ms(&blueled,1);

  rtc_init();
  
  while (true)
    {
      float xaccln=acclnread(&i2c,REG_OUT_X_MSB);
      float yaccln=acclnread(&i2c,REG_OUT_Y_MSB);
      float zaccln=acclnread(&i2c,REG_OUT_Z_MSB);
      printf("xaccln: %f yaccln: %f zaccln: %f Time: %d\r\n",
	     xaccln,yaccln,zaccln,rtc_read());
      float norm=sqrt(xaccln*xaccln+yaccln*yaccln);
      float xacclnorm=xaccln/norm;
      float yacclnorm=yaccln/norm;
      float rvec=xacclnorm*redx+yacclnorm*redy;
      float gvec=xacclnorm*greenx+yacclnorm*greeny;
      float bvec=xacclnorm*bluex+yacclnorm*bluey;
      pwmout_write(&redled,twothirds*(1.0f-rvec));
      pwmout_write(&greenled,twothirds*(1.0f-gvec));
      pwmout_write(&blueled,twothirds*(1.0f-bvec));
      wait(0.1f);
  }

}

