#include "mbed.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
  
  I2C i2c(SDA,SCL);

#define REG_WHO_AM_I      0x0D
#define REG_CTRL_REG_1    0x2A
#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05

#define MMA8451_I2C_ADDRESS (0x1d<<1)

// #define UINT14_MAX        16383
#define UINT14_MAX        16384

    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);

static const float redx=0.0f;
static const float redy=1.0f;
static const float greenx=sqrt(3.0f)/2.0f;
static const float greeny=-0.5f;
static const float bluex=-sqrt(3.0f)/2.0f;
static const float bluey=-0.5f;

static const float twothirds=2.0f/3.0f;


float acclnread(uint8_t reg)
{
  // Normalisation here seems wrong
  char t[1]= {reg};
  i2c.write(MMA8451_I2C_ADDRESS,t,1,true);
  uint8_t xbits[2] = {0,0};
  i2c.read(MMA8451_I2C_ADDRESS,(char *)xbits,2);
  int16_t xint = 0;
  xint=(xbits[0]<<6)|(xbits[1]>>2);
  // this sign flip code looks wrong, UINT14_MAX maps to 0
  // UINT14_MAX=16383, should it be UINT14_MAX=16384 
  if (xint > UINT14_MAX>>1)
    xint -= UINT14_MAX;
  return float(xint)/4096.0f;
  //  return float(xint);
}

int main(void)
{
  // initialise the accelerometer
  {
    uint8_t data[2] = {REG_CTRL_REG_1, 0x01};
    i2c.write(MMA8451_I2C_ADDRESS,(char *)data,2);
  }
  
  // read the who am i register
  {
    // this sets the pointer in the I2C decice (accelerometer)
    // to point to the who_am_i register
    char t[1] = {REG_WHO_AM_I};
    i2c.write(MMA8451_I2C_ADDRESS,t,1,true);
    // and this reads the register
    uint8_t who_am_i = 0;
    i2c.read(MMA8451_I2C_ADDRESS,(char *)&who_am_i,1);
    printf("\r\nMMA8451 ID: %d\r\n", who_am_i );
  }
  // initially set leds off
  rled=1.0f;
  gled=1.0f;
  bled=1.0f;
  // 1ms pwm frequency
  rled.period(0.001f);
  gled.period(0.001f);
  bled.period(0.001f);
  
  while (true) {

    float xaccln,yaccln;
    xaccln=acclnread(REG_OUT_X_MSB);
    yaccln=acclnread(REG_OUT_Y_MSB);
    float norm=sqrt(xaccln*xaccln + yaccln*yaccln);
    float xacclnorm=xaccln/norm;
    float yacclnorm=yaccln/norm;
    
    rled=twothirds*(1.0f-(xacclnorm*redx+yacclnorm*redy));
    gled=twothirds*(1.0f-(xacclnorm*greenx+yacclnorm*greeny));
    bled=twothirds*(1.0f-(xacclnorm*bluex+yacclnorm*bluey));
    
    //    rled = 1.0f + xaccln;
    //    gled = 1.0f + yaccln;

    printf("X: %1.4f, Y: %1.4f Norm: %1.4f R: %1.4f G: %1.4f B: %1.4f\r\n",
	   xaccln, yaccln,
	   norm,
	   1.0f-rled.read(),1.0f-gled.read(),1.0f-bled.read());
    wait(0.1f);
    // sleep(); // keeps the pwm alive
    // deepsleep(); // also keeps pwm alive
    //  __WFI();

  }
}

