#include "mbed.h"
#include "EthernetInterface.h"

EthernetInterface* myEth;

#define ECHO_SERVER_PORT 1234

int main() 
{
    myEth=new EthernetInterface();  //create the instance
    myEth->init();    //use DHCP
    myEth->connect();  
    printf("IP Address is %s\r\n",myEth->getIPAddress());
    
    TCPSocketServer* server=new TCPSocketServer();
    server->bind(ECHO_SERVER_PORT);
    
    server->listen();
    
    while(1)
    {
        printf("\r\nWait for new connection...\r\n");
        TCPSocketConnection* client=new TCPSocketConnection();
        server->accept((TCPSocketConnection&)*client);
        client->set_blocking(false,1500);
        
        printf("Connection from: %s\r\n",client->get_address());
        char buffer[256];
        while(1)
        {
            int n=client->receive(buffer,sizeof(buffer));
            printf("size of received char:%d\r\n",n);
            if(n<=0)
            {
                printf("No char received\r\n");
                //break;
            }
            else
            {
                if(client->send_all(buffer,n)<=0)
                    break;
            }
            wait(1);
        }
        client->close();
    }
}
