#include "mbed.h"
#include "uLCD_4DGL.h"
#include "XNucleo53L0A1.h"
#include <stdio.h>
#include "KeyPad.h"
#include <iostream>
#include "rtos.h"

DigitalOut shdn1(p26);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut Lock(p8);
DigitalIn  pb(p24);
KeyPad2 keypad(p15, p16, p12, p18, p19, p20, p25);
PwmOut pwm_pin(p21);
BusOut siren(LED4, LED3, LED2, LED1);
uLCD_4DGL display(p13, p14, p30); // serial tx, serial rx, reset pin;

// This VL53L0X board test application performs a range measurement in polling mode
// Use 3.3(Vout) for Vin, p28 for SDA, p27 for SCL, P26 for shdn on mbed LPC1768

//I2C sensor pins
#define VL53L0_I2C_SDA_1   p28
#define VL53L0_I2C_SCL_1   p27

#define VOLUME 0.1
#define BPM 100.0

static XNucleo53L0A1 *board1=NULL;
uLCD_4DGL uLCD(p13, p14, p30); // serial tx, serial rx, reset pin;

unsigned int count = 0;
unsigned int entered = 0;

unsigned int pin = 4180;

Thread sirenThread;

void playAlarm(float frequency, float duration, float volume);

float beat_duration = 60.0 / BPM;

void sirenOn() {
    while(true) {
        siren=15;
            playAlarm(587.330, (2*beat_duration - 0.4), VOLUME);
            siren=0;
            Thread::wait(400);
    }
}

int main()
{
    sirenThread.set_priority(osPriorityBelowNormal);
    pb.mode(PullUp);
    int distanceAtLock;
    int status1;
    int currentDistance;
    uint32_t distance1;
    DevI2C *device_i2c_1 = new DevI2C(VL53L0_I2C_SDA_1, VL53L0_I2C_SCL_1);
    /* creates the 53L0A1 expansion board singleton obj */
    board1 = XNucleo53L0A1::instance(device_i2c_1, A2, D8, D2);
    shdn1 = 0; //must reset sensor for an mbed reset to work
    wait(0.1);
    shdn1 = 1;
    wait(0.1);
    /* init the 53L0A1 board with default values */
    status1 = board1->init_board();
    while (status1) {
        
        status1 = board1->init_board();
    }
    int pin[4]= {4,1,8,0};
    int entry[4];
    bool pinCorrect;
    int k = 0;
    std::vector<int> keys;
    
    
    display.cls();
    display.color(LGREY);
    display.text_width(2);
    display.text_height(2);
    display.printf("ECE 4180\n\n  Home\n\nSecurity\n\n System");
    wait(2.5);
    display.cls();
    display.color(GREEN);
    display.locate(0,4);
    display.printf("System:");
    display.locate(8,4);
    display.printf("Disarmed ");
    Lock = 1;
    
    
    bool armed = false;
    bool triggered = false;

    while (1) {
        
        pinCorrect=false;
        status1 = board1->sensor_centre->get_distance(&distance1);

        if (status1 == VL53L0X_ERROR_NONE) {
            currentDistance = distance1;
            
        }
        
        if (armed||triggered){
            std::vector<int> keys = keypad.getkey();
            if (keys.size() > 0)
            {
                if (k==0) {
                    display.locate(4,10);
                    display.printf("            ");
                    display.locate(1,13);
                    display.printf("               ");
                }
                
                if (keys[0]==11) {entry[k]=0;}
                else {entry[k]=keys[0];}
                
                display.locate(k*3+4,10);
                display.printf("%d",entry[k]);
                k++;
                while (keys.size()){keys=keypad.getkey();}
                               
            }
        }
        
        
        if (k == 4) {
            if (entry[0]==pin[0] and entry[1]==pin[1] and entry[2]==pin[2] and entry[3]==pin[3])
            {
                pinCorrect=true;
                display.locate(4,13);
                display.printf("Pin Correct");
                
            } else {
                display.locate(3,13);
                display.printf("Pin Incorrect");
                
            }
            k = 0;
        }
        
        if (pb == 0) {
            armed = 1;
            Lock = 0;
            distanceAtLock = currentDistance;
            
            display.color(BLUE);
            display.locate(8,4);
            display.printf("Armed    ");
            display.locate(4,10);
            display.printf("            ");
            display.locate(1,13);
            display.printf("               ");
        }
        
        if (armed and (currentDistance < (distanceAtLock - 30))) {
            triggered = true;
        }
        
        if (triggered) {
            display.color(RED);
            display.locate(8,4);
            display.printf("Triggered");
            display.locate(0,7);
            display.printf("    Disarm Now");
            sirenThread.start(sirenOn);
            
            display.locate(0,7);
            display.printf("               ");
        }
        
        if (armed and pinCorrect) {
            armed = 0;
            triggered = 0;
            sirenThread.terminate();
            playAlarm(587.330, (0), VOLUME);
            siren=0;
            Lock = 1;
            
            display.color(GREEN);
            display.locate(8,4);
            display.printf("Disarmed ");
        }
    }
}


void playAlarm(float frequency, float duration, float volume)
{
    pwm_pin.period(1.0/frequency);
    pwm_pin = volume/2.0;
    wait(duration);
    pwm_pin = 0.0;
}
