#include "mbed.h"
#include "ili9325.h"
#include "lcd_base.h"
#include "display_modules.h"
#include "touch_modules.h"
#include "ecg_dec.h"
#include "touch_modules.h"
#include "glc.h"
#include "bp.h"
#include "sdcard.h"
#include "eeprom_pgm.h"

 
Serial gc(USBTX, USBRX);
DigitalIn q1(PTB11);
DigitalIn q(PTB8);
//Serial ble(PTC4,PTC3);



int main(){


 unsigned char state;
 unsigned char state1;
 unsigned char nstate;
 unsigned char nstate1;
 int pid=0;                // patient ID
 unsigned char flag=0;
 unsigned char ecg_flag=0;
 unsigned char glc_flag=0;

  
   DisableTouch();
   gc.baud(115200);
  
   init_screen();    //initialize lcd
   screen_main(); // display of main screen 
   state=1;
   flag=0;
   nstate=state;
   EnableTouch();   // enable touch function

   while(1)
   {
      
    detect_touch();     // determine the touch points
    
    switch(state)    // state for touch
  {
      case 1:   state1=touch_main();   // determining the touch for main screen 
                state=0;
                nstate1=state1;
                 break;
               
      case 2: 
                state1=touch_main_1();    // determining the touch for SYSTEM CONFIGURATION screen 
                state=0;
                nstate1=state1;
                break;
                
      case 3:  
               state1=touch_main_2();     //// determining the touch for TEST screen 
                                    
                state=0;
                nstate1=state1;
                break;
        
      case 4: 
                state1=touch_glc();     // determining the touch for GLC screen 
                state=0;
                nstate1=state1;
                break;       
        
      case 5: 
                state1=touch_ecg();     // determining the touch for ECG screen 
                state=0;
                nstate1=state1;
                 break;   
     case 6: 
                state1=touch_ret();     // determining the touch for returning back to the main screen 
                state=0;
                nstate1=state1;
                break;
                
     case 7: 
                state1=touch_again_ecg();     // determining the touch when readings are taken more than once screen 
                state=0;
                nstate1=state1;
                break;
                
     case 8:    
                state1=touch_bp();     // determining the touch for BP screen 
                state=0;
                nstate1=state1;
                break;           
                
     case 9:    state1=touch_again_glc();  
                state=0;
                nstate1=state1;
                break;            
                
     case 10 :  DisableTouch();
                 wait_ms(300);
                 EnableTouch();
                 state=nstate;
                  break;
                  
                  
      case 11:   state1=touch_again_bp();            
                 state=0;
                 nstate1=state1;
                 break;
      
      
     default :  DisableTouch();
                 wait_ms(300);
                 EnableTouch();
                 state=nstate;
                  break;          
                          
    }         
     

  
  
  
 switch(state1)    // state for display screens
  {

      
      case 1: DisableTouch();
                screen_main();        //  main screen 
                state1=0;
                state=1;
                nstate=state;
                flag=0;
                ecg_flag=0;             // ecg, glc flag to determine whether the readings are taken more than once
                glc_flag=0;
                EnableTouch();
                break;
      
      case 2: DisableTouch();
                screen_main_1();     // System configration screen 
                state1=0;
                state=2;
                nstate=state;
                EnableTouch();
                break;
               
      case 3: DisableTouch();
              if (flag==0)
              {
                //pid=pid+1;
                pid=eprom_read(1);         // reading the patient id from eeprom
                pid=pid+1;
               eprom_write(1,pid);         // writing the patient id to eeprom
                screen_main_2(pid);
                sd_open_GLCfilee(pid);     // only opening the glc,bp and ecg file
                 sd_close();
                 sd_open_ECGfilee(pid);
                 sd_close();
                 sd_open_BPfilee(pid);
                 sd_close();
                 flag=1;
                 }
               else
               {
               screen_main_2(pid);          // TEST screen 
               }
                 
                 state1=0;
                 state=3;
                 nstate=state;
                 EnableTouch();
                  break;
                
      case 4: DisableTouch();
               if (glc_flag==1)         // glc_flag=1 when already the reading has been taken 
               {
                  screen_again();    
                 state1=0;
                 state=9;
                 nstate=state;
                 }
            else
                { screen_glc();       // glc screen
                 state1=0;
                 state=4;
                 nstate=state;
                 }
                EnableTouch();
                
                break;
     
     
     case 5:     DisableTouch();
               if (ecg_flag==1)
               {
                  screen_again();
                  state1=0;
                   state=7;
                    nstate=state;
                    }
                    
                 else
                 {   
                  screen_ecg();       //ecg main screen 
                   state1=0;
                   state=5;
                    nstate=state;
                    }
                   EnableTouch();
                break;
     
     case 6:   DisableTouch();
               screen_bp();          // bp main screen
               EnableTouch();
                state1=0;
                state=8;
                break;
     
     
     
     
     
     case 7:    DisableTouch();     
                glc(pid);        // glc measurement
                glc_flag=1;
                wait(5); 
                state1=0;
                screen_glc_2();
                 state=6;;
              //  gc.printf("%d", state);
               EnableTouch();
                break;
    
    case 8:     DisableTouch();
                ecg_countdown();    // countdown before ecg capture
                ecg(pid);           // capturing ecg
                state1=0;
                screen_ecg_2();
                state=6;
                 nstate=state;
                 ecg_flag=1;
        //    ble.printf("ecg");
                EnableTouch();
                break;
     
     
     /*case 9: 
                DisableTouch();
                screen_glc_2();
                state1=0;
                state=6;
                nstate=state;
                EnableTouch();
                 break;*/
        
     case 9: 
                DisableTouch();
                screen_bp2();      // bp main screen
                bp();              // measuring bp   
                state1=0;
               // wait(1);
                state=6;
                nstate=state;
                EnableTouch();
                 break;
        
        
        
        default :  
                  
                  state1=nstate1;
                   break;          
                            
            
    }            
    
           
                
                
                
  }              
                
  
}







