#include "mbed.h"
#include "eeprom.h"
#include "eeprom_pgm.h"

#include <stdio.h> 
Serial ec(USBTX, USBRX); // tx, rx
EEPROM rom(PTC11, PTC10, 0x00, EEPROM::T24C32);
 
 
 

void eprom_write(uint32_t address, int8_t data) 
{
    rom.write(address ,data);           // write data into the address
 
}




int eprom_read(uint32_t address)       // readng the data from the specified address
{
    int8_t rdata;
    rom.read(address, rdata);        
    ec.printf("Read back value=%u\n", rdata);  
    return rdata;
}