#include "mbed.h"
#include "ili9325.h"
#include "lcd_base.h"
#include "display_modules.h"
#include "touch_modules.h"
#include "rtc.h"
//#include "main.h"


BusOut dataBus( PTC12, PTC13, PTB10, PTC9, PTD4, PTD5, PTD6, PTD7 ); // 16 pins//POC DISPALY 240*320 pixels
ILI9325_LCD lcd( PTC5, PTB9, PTC0, PTB0, &dataBus, NC, PTE31);


 void init_screen()     // initializing the screen
  {    
    lcd.Initialize(PORTRAIT);
  }

 void screen_main()     //main screen
 {
       char buff1[32];
        time_t epoch_time;
         lcd.ClearScreen();
         lcd.SetFont(&TerminusFont);
         epoch_time=rtc_read();                           // read the time from rtc module
        // sprintf(buff1 ,"%s", ctime(&epoch_time));        // display time on LCD
        strftime(buff1, 32, "%d/%m/%Y         %H:%M",localtime(&epoch_time));
         lcd.Print( buff1,20,100,COLOR_YELLOW,COLOR_BLACK, 0);
            lcd.SetFont(&TerminusBigFont);
            lcd.Print( "SENSESEMI",50,20,COLOR_WHITE,COLOR_BLACK, 0);
            lcd.Print( "SenseSmart",45,60,COLOR_WHITE,COLOR_BLACK, 0);// align text to center horizontally and use starndard colors
            lcd.FillRoundRect(60,130,180,200,COLOR_YELLOW);
            lcd.Print( "SYS",100,140,COLOR_BLACK,COLOR_YELLOW,0);
            lcd.Print( "CONFIG",70,170,COLOR_BLACK,COLOR_YELLOW,0);
            lcd.FillRoundRect(60,230,180,300,COLOR_GREEN);
            lcd.Print( "TEST",90,250,COLOR_BLACK,COLOR_GREEN,0);
     
  }
     
    
    
    void screen_main_2(int pid)     // test main screen
 {
     
     char buff2[10];
        
                lcd.FillRect(5,20,250,150,COLOR_BLACK); 
               //lcd.Print( "SenseSmart", CENTER, 95);
                sprintf(buff2 ,"%d", pid);
                lcd.Print( "PATIENT ID",20,50,COLOR_YELLOW,COLOR_BLACK, 0);
                lcd.Print(buff2,200,50,COLOR_YELLOW,COLOR_BLACK, 0);
                
                lcd.SetFont(&TerminusBigFont);
               // lcd.FillRect(5,120,230,320,COLOR_BLACK); 
                lcd.FillRoundRect(60,130,180,200,COLOR_BLACK);
                lcd.FillRoundRect(60,230,180,300,COLOR_BLACK);
                lcd.FillRoundRect(10,130,100,200,COLOR_CYAN);
                lcd.Print( "BG",40,160,COLOR_BLACK,COLOR_CYAN,0);
                lcd.FillRoundRect(130,130,220,200,COLOR_YELLOW);
                lcd.Print( "ECG",160,160,COLOR_BLACK,COLOR_YELLOW,0);
                lcd.FillRoundRect(10,215,100,285,COLOR_MAGENTA);
                lcd.Print( "BP",40,245,COLOR_BLACK,COLOR_MAGENTA,0);
                lcd.FillRoundRect(130,215,220,285,COLOR_GREEN);
                lcd.Print( "HOME",150,245,COLOR_BLACK,COLOR_GREEN,0);
       
                }         
                
                
                
    void screen_main_1() // System Configuration main screen
 {
      
                lcd.SetFont(&TerminusBigFont);
                lcd.FillRect(5,127,230,320,COLOR_BLACK); 
                lcd.FillRoundRect(10,130,100,200,COLOR_CYAN);
                lcd.Print( "BLE",30,160,COLOR_BLACK,COLOR_CYAN,0);
                lcd.FillRoundRect(130,130,220,200,COLOR_YELLOW);
                lcd.Print( "ERASE",140,160,COLOR_BLACK,COLOR_YELLOW,0);
                lcd.FillRoundRect(10,215,100,285,COLOR_MAGENTA);
                lcd.Print( "FILE",20,245,COLOR_BLACK,COLOR_MAGENTA,0);
                lcd.FillRoundRect(130,215,220,285,COLOR_GREEN);
                lcd.Print( "HOME",145,245,COLOR_BLACK,COLOR_GREEN,0);
      
                }                  
       
                
  void screen_ecg()    //ECG screen 1
   {
       
             //  lcd.FillRect(5,127,230,320,COLOR_BLACK); 
             lcd.FillRoundRect(10,130,100,200,COLOR_BLACK);
             lcd.FillRoundRect(130,130,220,200,COLOR_BLACK);
             lcd.FillRoundRect(10,215,100,285,COLOR_BLACK);
             lcd.FillRoundRect(130,215,220,285,COLOR_BLACK);
             lcd.FillRoundRect(60,130,180,200,COLOR_YELLOW);
             lcd.Print( "START",80,150,COLOR_BLACK,COLOR_YELLOW,0);
            // lcd.Print( "CONFIG",70,170,COLOR_BLACK,COLOR_YELLOW,0);
              lcd.FillRoundRect(60,230,180,300,COLOR_GREEN);
              lcd.Print( "RET",100,250,COLOR_BLACK,COLOR_GREEN,0);
     
     } 
      
      
                
 void screen_ecg_2()   // ECG screen 2
   {
       
              lcd.FillRect(5,90,230,150,COLOR_BLACK); 
              lcd.Print( "  Tst is Done  ",3,100,COLOR_GREEN,COLOR_BLACK,0);
              lcd.Print( "   HeartRate   ",3,150,COLOR_GREEN,COLOR_BLACK,0);
              lcd.Print( "    72 bpm",3,180,COLOR_CYAN,COLOR_BLACK,0);
           //  lcd.Print( "DONE", CENTER, 95);
            // lcd.Print( "s Done   ",80,150,COLOR_GREEN,COLOR_BLACK,0);
              lcd.FillRect(10,215,230,290,COLOR_BLACK);
          //  lcd.FillRoundRect(10,215,100,285,COLOR_MAGENTA);
           // lcd.FillRoundRect(130,215,220,285,COLOR_GREEN);
              lcd.FillRoundRect(60,230,180,300,COLOR_GREEN);
              lcd.Print( "RET",100,250,COLOR_BLACK,COLOR_GREEN,0);
        
    }                
       
       
                
 void screen_bp()          // BP main screen
 {
            lcd.FillRoundRect(10,130,100,200,COLOR_BLACK);
            lcd.FillRoundRect(130,130,220,200,COLOR_BLACK);
            lcd.FillRoundRect(10,215,100,285,COLOR_BLACK);
            lcd.FillRoundRect(130,215,220,285,COLOR_BLACK);
            lcd.FillRoundRect(60,130,180,200,COLOR_YELLOW);
            lcd.Print( "START",80,150,COLOR_BLACK,COLOR_YELLOW,0);
            // lcd.Print( "CONFIG",70,170,COLOR_BLACK,COLOR_YELLOW,0);
            lcd.FillRoundRect(60,230,180,300,COLOR_GREEN);
            lcd.Print( "RET",100,250,COLOR_BLACK,COLOR_GREEN,0);
 
    }
    

 void screen_bp1(float SBP, float DBP)          // BP  screen 2
 {
    
    char buf[10];    
        lcd.FillRoundRect(3,130,200,200,COLOR_BLACK);
        lcd.FillRoundRect(60,230,180,300,COLOR_BLACK);
        sprintf (buf, "SBP: %f",SBP);
        lcd.Print( buf, 5,100,COLOR_CYAN,COLOR_BLACK, 0);
        sprintf (buf, "DBP: %f",DBP);
        lcd.Print( buf, 5,150,COLOR_CYAN,COLOR_BLACK, 0);
        lcd.FillRoundRect(60,230,180,300,COLOR_GREEN);
        lcd.Print( "RET",100,250,COLOR_BLACK,COLOR_GREEN,0);
}   
    
    
                   
                
  
 void screen_glc()     // glc main screen
 {
        
                 //lcd.FillRect(5,127,230,320,COLOR_BLACK); 
              //   lcd.FillRect(5,127,230,320,COLOR_BLACK); 
        lcd.FillRoundRect(10,130,100,200,COLOR_BLACK);
        lcd.FillRoundRect(130,130,220,200,COLOR_BLACK);
        lcd.FillRoundRect(10,215,100,285,COLOR_BLACK);
        lcd.FillRoundRect(130,215,220,285,COLOR_BLACK);
        lcd.FillRoundRect(60,130,180,200,COLOR_YELLOW);
        lcd.Print( "START",80,150,COLOR_BLACK,COLOR_YELLOW,0);
        lcd.FillRoundRect(60,230,180,300,COLOR_GREEN);
        lcd.Print( "RET",100,250,COLOR_BLACK,COLOR_GREEN,0);
        
    }               


 void screen_bp2()    //BP screen 3
 {    
     
           lcd.FillRoundRect(3,130,200,200,COLOR_BLACK);
           lcd.FillRoundRect(60,230,180,300,COLOR_BLACK);
           lcd.FillRect(5,215,230,290,COLOR_BLACK);
           
}
            
     
 void ecg_countdown()   // ECG measurement countdown 
 {    
     char tim1[5];
     
         // lcd.DrawRect(20,90,90,40,COLOR_BLACK);
         // lcd.FillRect(5,127,230,320,COLOR_BLACK); 
        lcd.FillRoundRect(3,130,200,200,COLOR_BLACK);
        lcd.FillRoundRect(60,230,180,300,COLOR_BLACK);
        lcd.FillRect(5,215,230,290,COLOR_BLACK);
        lcd.Print( "ECG starts in", CENTER, 95);
    for(int i=5;i>=0;i--)
            {
                wait(1);
                sprintf (tim1, "%d",i);
                lcd.Print( tim1,120,120,COLOR_YELLOW,COLOR_BLACK, 0);
            }
            
        lcd.Print( "Tst in Progres",3,150,COLOR_GREEN,COLOR_BLACK,0);
      
  }                
  
  
  
 void screen_again()    // screen to press 'yes' or 'no' to repeat the test 
 {
   
          //lcd.DrawRect(20,90,90,40,COLOR_BLACK);
        lcd.FillRect(5,127,230,200,COLOR_BLACK); 
        lcd.Print( "Take test",50,130 ,COLOR_CYAN,COLOR_BLACK, 0);
        lcd.Print( "again?",75,160 ,COLOR_CYAN,COLOR_BLACK, 0);
        lcd.Print( "YES",30,245,COLOR_BLACK,COLOR_MAGENTA,0);
        lcd.Print( " NO ",150,245,COLOR_BLACK,COLOR_GREEN,0);
   //lcd.FillRect(5 ,127,230,200,COLOR_BLACK); 
  }
  
  
  void screen_glc_2()   // GLC screen 3 after test 
   {
       
          lcd.FillRect(5,127,230,320,COLOR_BLACK); 
          lcd.FillRoundRect(60,230,180,300,COLOR_GREEN);
          lcd.Print( "RET",100,250,COLOR_BLACK,COLOR_GREEN,0);
    }  
  
  
  void glc_1()     // GLC screen 
  {
      
           lcd.FillRoundRect(3,130,200,200,COLOR_BLACK);
           lcd.FillRoundRect(60,230,180,300,COLOR_BLACK);
           lcd.FillRect(5,215,230,290,COLOR_BLACK);
           lcd.Print( "BLOOD GLUCOSE",20,130 ,COLOR_CYAN,COLOR_BLACK, 0); // align text to center horizontally and use starndard colors
           lcd.Print( "Insert strip",5,160,COLOR_MAGENTA,COLOR_BLACK, 0); // align text to center horizontally and use starndard colors
  }
  
   void glc_2()     // GLC screen 
  {
    
     lcd.Print( "Strip Detected",5,160, COLOR_GREEN,COLOR_BLACK, 0);
     lcd.Print( "Insert Blood",5,190,COLOR_RED,COLOR_BLACK, 0);
   }
   
 
  void glc_3()     // GLC screen 
  {
      
     lcd.Print( "Blood Detected",5,190,COLOR_GREEN,COLOR_BLACK, 0);
     lcd.Print( "computing", 5,220,COLOR_MAGENTA,COLOR_BLACK, 0);
   }
   
  
  void glc_4(unsigned int mgdl)   // GLC screen to display blood glucose level on the LCD
   {
   
     lcd.FillRect(5,127,230,320,COLOR_BLACK); 
     char buf[10];
     sprintf (buf, " BG %d mg/dl",mgdl);
     lcd.Print( buf, 5,100,COLOR_YELLOW,COLOR_BLACK, 0);
   }