/**
 * Copyright (c) 2017, Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <stdio.h>
#include "th02.h"
#include "CayenneLPP.h"
#include "lorawan/LoRaWANInterface.h"
#include "lorawan/system/lorawan_data_structures.h"
#include "events/EventQueue.h"

// Application helpers
#include "DummySensor.h"
#include "trace_helper.h"
#include "lora_radio_helper.h"
#include "Servo.h"

using namespace events;

// Max payload size can be LORAMAC_PHY_MAXPAYLOAD.
// This example only communicates with much shorter messages (<30 uint8_ts).
// If longer messages are used, these buffers must be changed accordingly.
uint8_t tx_buffer[30];
uint8_t rx_buffer[30];

#define MAX_SIZE 200 // depends on spreading factor and frequency used

CayenneLPP Payload(MAX_SIZE);

float celsius = -4.1;
float accel[] = {1.234, -1.234, 0};
float rh = 30;
float hpa = 1014.1;
float latitude = 42.3519;
float longitude = -87.9094;
float altitude=10;

int size = 0;


/*DigitalOut Alarme (PC_13);// alarme LED output
Servo Myservo(PA_7); //servomotor output
TH02 MyTH02 (I2C_SDA,I2C_SCL,TH02_I2C_ADDR<<1);// connect hsensor on RX2 TX2*/ 

/*
 * Sets up an application dependent transmission timer in ms. Used only when Duty Cycling is off for testing
 */
#define TX_TIMER                        20000

/**
 * Maximum number of events for the event queue.
 * 10 is the safe number for the stack events, however, if application
 * also uses the queue for whatever purposes, this number should be increased.
 */
#define MAX_NUMBER_OF_EVENTS            30

/**
 * Maximum number of retries for CONFIRMED messages before giving up
 */
#define CONFIRMED_MSG_RETRY_COUNTER     3

/**
 * Dummy pin for dummy sensor
 */
#define PC_9                            0

/**
 * Dummy sensor class object
 */
DS1820  ds1820(PC_9);

//adc internal temperature
AnalogIn adc_temp(ADC_TEMP);
#define TCAL_30                                           ((uint16_t *)(0x1FF8007A ))//des valeurs pour la calibration
#define TCAL_130                                          ((uint16_t *)(0x1FF8007E ))

#define CALIBRATION_REFERENCE_VOLTAGE                     ((uint16_t *)(0x1FF80078 ))

#define REFERENCE_VOLTAGE                                 3.0F // supplied with Vref+ or VDDA

uint8_t calculcrc(uint8_t[],int);
uint8_t simplecrc8(uint8_t);

/**
* This event queue is the global event queue for both the
* application and stack. To conserve memory, the stack is designed to run
* in the same thread as the application and the application is responsible for
* providing an event queue to the stack that will be used for ISR deferment as
* well as application information event queuing.
*/
static EventQueue ev_queue(MAX_NUMBER_OF_EVENTS *EVENTS_EVENT_SIZE);

/**
 * Event handler.
 *
 * This will be passed to the LoRaWAN stack to queue events for the
 * application which in turn drive the application.
 */
static void lora_event_handler(lorawan_event_t event);

/**
 * Constructing Mbed LoRaWANInterface and passing it the radio object from lora_radio_helper.
 */
static LoRaWANInterface lorawan(radio);

/**
 * Application specific callbacks
 */
static lorawan_app_callbacks_t callbacks;

void servo(uint8_t uAngle)
{
    
    }



/**
 * Entry point for application
 */
int main(void)
{
    // setup tracing
    setup_trace();
   /*  th02 temerature sensor section 
    int iTemp,iTime,iTempbrute,iRH,iRHbrute;
    printf ("\n\r start reading TH02 for first time");
     MyTH02.startTempConv(true,true);*/
  



    // stores the status of a call to LoRaWAN protocol
    lorawan_status_t retcode;

    // Initialize LoRaWAN stack
    if (lorawan.initialize(&ev_queue) != LORAWAN_STATUS_OK) {
        printf("\r\n LoRa initialization failed! \r\n");
        return -1;
    }

    printf("\r\n Mbed LoRaWANStack initialized \r\n");

    // prepare application callbacks
    callbacks.events = mbed::callback(lora_event_handler);
    lorawan.add_app_callbacks(&callbacks);

    // Set number of retries in case of CONFIRMED messages
    if (lorawan.set_confirmed_msg_retries(CONFIRMED_MSG_RETRY_COUNTER)
            != LORAWAN_STATUS_OK) {
        printf("\r\n set_confirmed_msg_retries failed! \r\n\r\n");
        return -1;
    }

    printf("\r\n CONFIRMED message retries : %d \r\n",
           CONFIRMED_MSG_RETRY_COUNTER);

    // Enable adaptive data rate
    if (lorawan.enable_adaptive_datarate() != LORAWAN_STATUS_OK) {
        printf("\r\n enable_adaptive_datarate failed! \r\n");
        return -1;
    }

    printf("\r\n Adaptive data  rate (ADR) - Enabled \r\n");

    retcode = lorawan.connect();

    if (retcode == LORAWAN_STATUS_OK ||
            retcode == LORAWAN_STATUS_CONNECT_IN_PROGRESS) {
    } else {
        printf("\r\n Connection error, code = %d \r\n", retcode);
        return -1;
    }

    printf("\r\n Connection - In Progress ...\r\n");

    // make your event queue dispatching events forever
    ev_queue.dispatch_forever();

    return 0;
}

/*****************************************************
 * Sends a message to the Network Server
 *****************************************************/
static void send_message()
 {int iTime,iTempbrute,iRHbrute;   
 uint16_t packet_len;
    int16_t retcode;
    int32_t sensor_value, temp_value, rh_value;
    float adcCalTemp30C,adcCalTemp130C,ftemp;
    double temp;
    uint8_t badge, crc1, crc2;uint8_t ibadge[] = {0x1A, 0x14, 0xA3, 0xB5, 0xC4, 0x03, 0x2E, 0x61, 0x52, 0x32, 0x46};

 /*MyTH02.startTempConv(true,true);
    iTime= MyTH02.waitEndConversion();// wait until onversion  is done
     iTempbrute= MyTH02.getConversionValue();
    sensor_value=MyTH02.getLastRawTemp();
    printf ("\n\r temp value=%d  %d",sensor_value,iTempbrute );*/

     adcCalTemp30C = *TCAL_30 * (REFERENCE_VOLTAGE/ *CALIBRATION_REFERENCE_VOLTAGE);
     adcCalTemp130C = *TCAL_130 * (REFERENCE_VOLTAGE/ *CALIBRATION_REFERENCE_VOLTAGE);
     
     /*printf("reference voltage %x\r\n", *CALIBRATION_REFERENCE_VOLTAGE);
     printf("30 degrees %x\r\n", *TCAL_30);
     printf("130 degrees %x\r\n", *TCAL_130);*/
     
     badge = 0x1A;
     crc1 = simplecrc8(badge);
     printf("crcsend = %x\r\n\n\n", crc1);
     crc2 = calculcrc(ibadge, sizeof(ibadge));
     printf("crcreceive = %x\r\n", crc2);
     
       /* temp=adc_temp.read_u16();
        printf("ADC Temp Value = %f\r\n", temp);
        ftemp = ( ( (130 - 30)*(temp - *TCAL_30) ) / (*TCAL_130 - *TCAL_30) ) + 30;
        printf("temperature = %f \r\n",ftemp); */
    
    if (ds1820.begin()) {
        ds1820.startConversion();
        sensor_value = ds1820.read();
        printf("\r\n Dummy Sensor Value = %d \r\n", sensor_value);
        ds1820.startConversion();
    } else {
        printf("\r\n No sensor found \r\n");
        return;
    }
    
    Payload.reset();
    Payload.addTemperature(1, (float) sensor_value/100);
    Payload.addRelativeHumidity(2, (float) sensor_value/10);
    Payload.addDigitalInput(3, sensor_value);
   


      retcode = lorawan.send(MBED_CONF_LORA_APP_PORT, Payload.getBuffer(), Payload.getSize(),
                           MSG_UNCONFIRMED_FLAG);                

    if (retcode < 0) {
        retcode == LORAWAN_STATUS_WOULD_BLOCK ? printf("send - WOULD BLOCK\r\n")
        : printf("\r\n send() - Error code %d \r\n", retcode);

        if (retcode == LORAWAN_STATUS_WOULD_BLOCK) {
            //retry in 3 seconds
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                ev_queue.call_in(3000, send_message);
            }
        }
        return;
    }

    printf("\r\n %d uint8_ts scheduled for transmission \r\n", retcode);
    memset(Payload.getBuffer(), 0, Payload.getSize());
}

/*************************************************
 * Receive a message from the Network Server
 *************************************************/
static void receive_message()
{int num_port;
    uint8_t port;
    int flags;
    int16_t retcode = lorawan.receive(rx_buffer, sizeof(rx_buffer), port, flags);

    if (retcode < 0) {
        printf("\r\n receive() - Error code %d \r\n", retcode);
        return;
    }

    printf(" RX Data on port %u (%d uint8_ts): ", port, retcode);
    for (uint8_t i = 0; i < retcode; i++) {
        printf("%02x", rx_buffer[i]);
    }
     printf("\n test value=%d", port); 
 // code todo here
   
        
    memset(rx_buffer, 0, sizeof(rx_buffer));
}

/******************
 * Event handler
 *****************/
static void lora_event_handler(lorawan_event_t event)
{
    switch (event) {
        case CONNECTED:
            printf("\r\n Connection - Successful \r\n");
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                send_message();
            } else {
                ev_queue.call_every(TX_TIMER, send_message);
            }

            break;
        case DISCONNECTED:
            ev_queue.break_dispatch();
            printf("\r\n Disconnected Successfully \r\n");
            break;
        case TX_DONE:
            printf("\r\n Message Sent to Network Server \r\n");
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                send_message();
            }
            break;
        case TX_TIMEOUT:
        case TX_ERROR:
        case TX_CRYPTO_ERROR:
        case TX_SCHEDULING_ERROR:
            printf("\r\n Transmission Error - EventCode = %d \r\n", event);
            // try again
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                send_message();
            }
            break;
        case RX_DONE:
            printf("\r\n Received message from Network Server \r\n");
            receive_message();
            break;
        case RX_TIMEOUT:
         printf("\r\n timeout in reception - Code = %d \r\n", event);
            break;
        case RX_ERROR:
            printf("\r\n Error in reception - Code = %d \r\n", event);
            break;
        case JOIN_FAILURE:
            printf("\r\n OTAA Failed - Check Keys \r\n");
            break;
        case UPLINK_REQUIRED:
            printf("\r\n Uplink required by NS \r\n");
            if (MBED_CONF_LORA_DUTY_CYCLE_ON) {
                send_message();
            }
            break;
        default:
            MBED_ASSERT("Unknown Event");
    }
}

// EOF

/******************
 * Calcul CRC
 *****************/
uint8_t calculcrc(uint8_t *byteVal, int taille)
{
    uint8_t generator = 0x07;
    uint8_t crc = 0; /* start with 0 so first byte can be 'xored' in */
    
    printf("byteval = %x%x%x%x%x%x%x%x%x%x\r\n", *byteVal, *(byteVal+1), *(byteVal+2), *(byteVal+3), *(byteVal+4), *(byteVal+5), *(byteVal+6), *(byteVal+7), *(byteVal+8), *(byteVal+9), *(byteVal+10)); 

    for(int i=0; i<taille; i++)
    {
        printf("current byte = %x\r\n",byteVal[i]);
        crc ^= byteVal[i]; /* XOR-in the next input byte */
        printf("current crc = %x\r\n", crc);

        for (int j = 0; j < 8; j++)
        {
            printf("msbcrc = %x\r\n", crc & 0x80);
            if ((crc & 0x80) != 0)
            {
                crc = (uint8_t)((crc << 1) ^ generator);
                printf("crc = %x\r\n", crc);
            }
            else
            {
                crc <<= 1;
                printf("msbcrc 0 so we shift = %x\r\n", crc);
            }
        }
    }

    return crc;
} 

uint8_t simplecrc8(uint8_t byteVal)
{
    uint8_t generator = 0x07;
    uint8_t crc = byteVal; /* init crc directly with input byte instead of 0, avoid useless 8 bitshifts until input byte is in crc register */
    printf("byteval = %x\r\n", crc);

    for (int i = 0; i < 8; i++)
    {
        printf("msbcrc = %x\r\n", crc & 0x80);
        if ((crc & 0x80) != 0)
        { /* most significant bit set, shift crc register and perform XOR operation, taking not-saved 9th set bit into account */
            crc = (uint8_t)((crc << 1) ^ generator);
            printf("crc after xor with generator = %x\r\n", crc);
        }
        else
        { /* most significant bit not set, go to next bit */
            crc <<= 1;
            printf("msbcrc is zero, we shift = %x\r\n", crc);
        }
    }

    return crc;
} 
