#include "mbed.h"
#include "BufferedSerial.h"


#define RECEIVE_BUFF_LENGT      120
#define MAXIMUM_BUFFER_SIZE     32



PwmOut buzzer(p21);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut pin22(p22);
DigitalOut pin23(p23);
DigitalOut pin24(p24);

BufferedSerial  pc(USBTX, USBRX);

float   frequency = 100;
float   delay = 0.1;
float   tempo_trascorso_ultimo_pwm_refresh = 0;
float   tempo_ultimo_pwm_refresh = 0;
float   Freq_Period_2 = 0;
float   Freq_Period_3 = 0;

int new_data = 0;

Ticker Task_Controllo_freq;
Ticker Task_Freq_Gen_2;
Ticker Task_Freq_Gen_3;
Timer tempo;

void flip_2()
{
    pin22 = !pin22;
}

void flip_3()
{
    pin23 = !pin23;
}

void Gestione_frequenza()
{
    tempo_trascorso_ultimo_pwm_refresh = tempo.read() - tempo_ultimo_pwm_refresh;
    if(tempo_trascorso_ultimo_pwm_refresh > delay) {
        buzzer.period(1.0/(frequency)); // set PWM period
        buzzer=0.5; // set duty cycle
        delay = 1.0 /(frequency);
        tempo_trascorso_ultimo_pwm_refresh = tempo.read();
        Freq_Period_2 = 1.0/(2*frequency);
        Freq_Period_3 = 1.0/(1.8*frequency);
        Task_Freq_Gen_2.attach(flip_2,Freq_Period_2);
        Task_Freq_Gen_3.attach(flip_3,Freq_Period_3);
        frequency = frequency + 1000;
        if(frequency > 20000)
            frequency = 1000;
    }

}




int main()
{
    uint32_t num;
    // Application buffer to receive the data
    char buf[MAXIMUM_BUFFER_SIZE] = {0};

    pc.baud(115200);
    pc.format(8,Serial::None,2);
//    pc.attach(&pc_recv, Serial::RxIrq);


    frequency = 1000;
    Task_Controllo_freq.attach(&Gestione_frequenza, 0.05);
    tempo.start();
    tempo_ultimo_pwm_refresh = tempo.read();

    while(1) {
//        led1=!led1;
//        pin24=!pin24;
//        wait(1.0);

        //if (num = pc.read(buf, sizeof(buf))) 
        if(0)
        {
            // Toggle the LED.
            led2 = !led2;

            // Echo the input back to the terminal.
            pc.write(buf, num);
        }

    }
}