#include "mbed.h"
#include "rtos.h"
 
Serial pc(USBTX, USBRX);
//TX RX pins, see https://mbed.org/handbook/mbed-FRDM-KL25Z
Serial uart(p9, p10);
//to test is you can use a hard bridge (piece of cable) between PTC4 and PTC3 open a terminal and write something :) 
//you can integrate this to improve some interesting aplicattions like this:
//http://www.instructables.com/id/Temperature-sensor--weatherstation/http://www.instructables.com/id/Temperature-sensor--weatherstation/ 
DigitalOut pc_activity(LED1);
DigitalOut uart_activity(LED2);
DigitalIn receive(p10);

Timer t;
int state = 0;
int period = 0;
int baud_rate = 0;
 
void baud_thread(void const *args) {
    while (true) {
        uart.putc(0x55);        
        Thread::wait(1000);
        if (period)
            pc.printf("baud rate %d ", baud_rate);
    }
}

void get_rate(int *baud_rate) {    
    if (*baud_rate > 90000 && *baud_rate < (int)(125200))
        *baud_rate = 115200;
    else if (*baud_rate > (int)0.9*9600 && *baud_rate < (int)1.1*9600)
        *baud_rate = 9600;
    else
        *baud_rate = 0;
}
            

int main() {

    int stop = 0;
    int counter = 0;
    uart.baud(115200);
    Thread thread(baud_thread);
    
    pc.printf("started \n");
    while(1) {
        if (state == 0)
            if(receive) {
                state = 1;
            }
            
        if (state == 1)
            if(!receive) {
                t.start();
                state = 2;
            }
            
        if (state == 2)
            if(receive) {
                t.stop();
                period = t.read_us();
                baud_rate = (int)(1.0/((float)t.read_us()/1000000.0));
                get_rate(&baud_rate);
                uart.putc(0xAA);
                t.reset();
                state = 0;
            }
        
        if(pc.readable()) {
            uart.putc(pc.getc());
            pc_activity = !pc_activity;
        }
        
        if(uart.readable()) {
            pc.putc(uart.getc());
            uart_activity = !uart_activity;
        }
    }
}