/*----------------------------------------------------------------------------
LAB EXERCISE 9 - Analog input and PWM
 ----------------------------------------
	Use two potentiometers to adjust the volume and pitch of the output sound wave.
	
	Inputs: Virtual potentiometers 1 and 2
	Output: Virtual speaker,  Real PC

	GOOD LUCK!
 *----------------------------------------------------------------------------*/

#include "mbed.h"


/*
Define the PWM speaker output
Define analog inputs
Define serial output
*/
#define POT1 (PA_0)			// Analog input for potentiomenter 1: volume 
#define POT2 (PA_1)			// Analog input for potentiometer 2: pitch
#define PWM_SPEAKER (PB_10)		// output pin connected to speaker

float constant1 = 0.003;		// within range 320Hz to 8kHz
float constant2 = 0.000125;

AnalogIn pot1(POT1);			//Create an AnalogIn , connected to the specified pin
AnalogIn pot2(POT2);

float pot1_value;			// To read values from potentiometers
float pot2_value;

PwmOut speaker(PWM_SPEAKER);
Serial serial_output(USBTX, USBRX);
/*----------------------------------------------------------------------------
 MAIN function
 *----------------------------------------------------------------------------*/
    
int main() 
{
    
    double i = 0;
    while(1)
    {
	// Read values from the potentiometers
        pot1_value = pot1.read();
        pot2_value = pot2.read();
        printf("\n\r%f %f",pot1_value, pot2_value);			// Print potentiometer values
        wait(0.5);
        
        for(i=0; i<pot1_value; i+=0.05)					// adjusting the PWM steps. s
        {
            speaker = i;
            speaker.period(constant1*pot2_value + constant2);		// variations in pitch is given to output
        }
        speaker.write(pot1_value);					// volume output given to speaker
        
    }
}
// *******************************ARM University Program Copyright � ARM Ltd 2014*************************************


