/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_BUTTON_SERVICE_H__
#define __BLE_BUTTON_SERVICE_H__

class ButtonService {
public:
    const static uint16_t BUTTON_SERVICE_UUID              = 0xA000;
    const static uint16_t BUTTON_STATE_CHARACTERISTIC_UUID = 0xA001;
    const static uint16_t INTERRUPT_STATE_CHARACTERISTIC_UUID = 0xA002;
    const static uint16_t GYRO_STATE_CHARACTERISTIC_UUID = 0xA003;
    
    
    const static uint16_t MOTION_THRESHOLD_CHARACTERISTIC_UUID = 0xA004;
    const static uint16_t MOTION_DURATION_CHARACTERISTIC_UUID = 0xA005;
    
      const static uint16_t ZERO_MOTION_THRESHOLD_CHARACTERISTIC_UUID = 0xA006;
    const static uint16_t ZERO_MOTION_DURATION_CHARACTERISTIC_UUID = 0xA007;

    ButtonService(BLE &_ble, float buttonPressedInitial, float interruptInitial, float gyroInitial, uint8_t motionThresholdInitial, uint8_t motionDurationInitial, uint8_t zeroMotionThresholdInitial, uint8_t zeroMotionDurationInitial) :
        ble(_ble), buttonState(BUTTON_STATE_CHARACTERISTIC_UUID, &buttonPressedInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                   interruptState(INTERRUPT_STATE_CHARACTERISTIC_UUID, &interruptInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                   gyroState(GYRO_STATE_CHARACTERISTIC_UUID, &gyroInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                   motionThreshold(MOTION_THRESHOLD_CHARACTERISTIC_UUID, &motionThresholdInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                   motionDuration(MOTION_DURATION_CHARACTERISTIC_UUID, &motionDurationInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                   zeroMotionThreshold(ZERO_MOTION_THRESHOLD_CHARACTERISTIC_UUID, &zeroMotionThresholdInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                   zeroMotionDuration(ZERO_MOTION_DURATION_CHARACTERISTIC_UUID, &zeroMotionDurationInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&buttonState,&interruptState, &gyroState, &motionThreshold, &motionDuration};
        GattService         buttonService(ButtonService::BUTTON_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(buttonService);
    }

    void updateButtonState(float newState) {
        
        ble.gattServer().write(buttonState.getValueHandle(), (uint8_t *)&newState, sizeof(float));
    }
    
    void updateInterruptState(float newState) {
        ble.gattServer().write(interruptState.getValueHandle(), (uint8_t *)&newState, sizeof(float));
        }

void updateGyroState(float newState) {
        ble.gattServer().write(gyroState.getValueHandle(), (uint8_t *)&newState, sizeof(float));
        }

private:
    BLE                              &ble;
    ReadOnlyGattCharacteristic<float>  buttonState;
    ReadOnlyGattCharacteristic<float>  interruptState;
    ReadOnlyGattCharacteristic<float>  gyroState;
    WriteOnlyGattCharacteristic<uint8_t>  motionThreshold;
    WriteOnlyGattCharacteristic<uint8_t>  motionDuration;
    
    WriteOnlyGattCharacteristic<uint8_t>  zeroMotionThreshold;
    WriteOnlyGattCharacteristic<uint8_t>  zeroMotionDuration;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */