#ifndef __BLE_MOTOR_SERVICE_H_
#define __BLE_MOTOR_SERVICE_H_

#include "ble/BLE.h"
#include "UUID.h"

extern const uint8_t MOTOR_SERVICE_LONG_UUID[UUID::LENGTH_OF_LONG_UUID];
extern const uint8_t MOTOR_1_CHARACTERISTIC_LONG_UUID[UUID::LENGTH_OF_LONG_UUID];
extern const uint8_t MOTOR_2_CHARACTERISTIC_LONG_UUID[UUID::LENGTH_OF_LONG_UUID];
extern const uint8_t MOTOR_3_CHARACTERISTIC_LONG_UUID[UUID::LENGTH_OF_LONG_UUID];


class MotorService {
public:

    const static uint16_t TEST_CHARACTERISTIC_UUID = 0xA011;


    MotorService(BLEDevice &_ble, float initialValueMotor1, float initialValueMotor2, float initialValueMotor3) :
        ble(_ble), 
        motor1(MOTOR_1_CHARACTERISTIC_LONG_UUID, &initialValueMotor1), 
        motor2(MOTOR_2_CHARACTERISTIC_LONG_UUID, &initialValueMotor2), 
        motor3(MOTOR_3_CHARACTERISTIC_LONG_UUID, &initialValueMotor3)
    {
        GattCharacteristic *charTable[] = {&motor1, &motor2, &motor3};
        GattService         motorService(MOTOR_SERVICE_LONG_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(motorService);
    }

    GattAttribute::Handle_t getValueHandleMotor1() const {
        return motor1.getValueHandle();
    }

    GattAttribute::Handle_t getValueHandleMotor2() const {
        return motor2.getValueHandle();
    }

    GattAttribute::Handle_t getValueHandleMotor3() const {
        return motor3.getValueHandle();
    }

    
private:
    BLEDevice                         &ble;
    
    ReadWriteGattCharacteristic<float>  motor1;
    ReadWriteGattCharacteristic<float>  motor2;
    ReadWriteGattCharacteristic<float>  motor3;
};

#endif /* #ifndef __BLE_MOTOR_SERVICE_H_ */

