#ifndef __BLE_MPU_SERVICE_H__
#define __BLE_MPU_SERVICE_H__

class MPUService {
public:
    const static uint16_t MPU_SERVICE_UUID              = 0xA000;
    const static uint16_t MPU_STATE_CHARACTERISTIC_UUID = 0xA001;

    MPUService(BLEDevice &_ble, double x) :
        ble(_ble), mpuState(MPU_STATE_CHARACTERISTIC_UUID, &x,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&mpuState};
        GattService         mpuService(MPU_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(mpuService);
    }

    GattAttribute::Handle_t getValueHandle() const
    {
        return mpuState.getValueHandle();
    }
     void updateSensorValue(double newValue) {
        ble.gattServer().write(mpuState.getValueHandle(), (uint8_t *)&newValue, sizeof(double));
    }

private:
    BLEDevice                         &ble;
    ReadWriteGattCharacteristic<double> mpuState;
};

#endif /* #ifndef __BLE_MPU_SERVICE_H__ */