#include "SIM5320.h"
#include <string>

SIM5320::SIM5320() : SIM5320Serial(PA_9, PA_10), debugSerial(USBTX, USBRX)
{
    SIM5320Serial.baud(115200);
    debugSerial.baud(115200);
    SIM5320Serial.attach(callback(this,&SIM5320::rxInterrupt),Serial::RxIrq);
    flushBuffer();
    rx_in=0;
}

SIM5320::SIM5320(PinName tx, PinName rx, bool debug) : SIM5320Serial(tx, rx), debugSerial(USBTX, USBRX)
{
    SIM5320Serial.baud(115200);
    debugSerial.baud(115200);
    SIM5320Serial.attach(callback(this,&SIM5320::rxInterrupt),Serial::RxIrq);
    flushBuffer();
    rx_in=0;
}

string SIM5320::sendCommand(const char *command, uint8_t timeout)
{
    //printDebug(command);
    SIM5320Serial.printf("%s\r\n", command);
    wait(timeout);
    string ret = readBuffer();
    const char* debugResponse = rx_buffer;
    printDebug(debugResponse);
    flushBuffer();
    return ret;


}

uint8_t SIM5320::sendCommandAndCheck(const char *command, const char *response, uint8_t timeout)
{
    string answer = sendCommand(command, timeout);

    string resp(response);
    if (answer.find(resp) != string::npos) {
        return 1;
    }
    return 0;
}
void SIM5320::printDebug(const char *line)
{
    debugSerial.printf("%s\n",line);
}
bool SIM5320::connect(const char *apn, const char *userName, const char *passPhrase)
{
    sendCommand("AT",2);
    sendCommand("AT+CSQ",2);
    sendCommand("AT+CREG?",2);
    sendCommand("AT+CPSI?",2);
    sendCommand("AT+CGREG?",2);
    sendCommand(concatChars("AT+CGSOCKCONT=1,\"IP\",\"",apn,"\""),3);
    sendCommand("AT+CSOCKSETPN=1",2);
    sendCommand("AT+CIPMODE=0",2);
    sendCommand("AT+NETOPEN",10);
    return sendCommandAndCheck("AT+IPADDR","IPADDR",3);
}
bool SIM5320::disconnect()
{
    sendCommand("AT+NETCLOSE",2);
    return sendCommandAndCheck("AT+IPADDR","IP ERROR",2);
}
bool SIM5320::enableGPS(bool isEnabled)
{
    char x='0';
    if(isEnabled) {
        x='1';
    } else {
        x='0';
    }
    return sendCommandAndCheck("AT+CGPS=1","OK",3);
}
void SIM5320::rxInterrupt()
{
    while(SIM5320Serial.readable()) {
        char c = SIM5320Serial.getc();
        rx_buffer[rx_in] = c;
        rx_in++;
        if(rx_in==BUFFER_SIZE)
            rx_in=0;
    }
    return;
}

string SIM5320::readBuffer()
{

    return string(rx_buffer);
}

void SIM5320::flushBuffer()
{
    for(int i=0; i<BUFFER_SIZE; i++)
        rx_buffer[i]=0;
    rx_in=0;
}

char* SIM5320::concatChars(const char* in1, const char* in2, const char* in3)
{
    char* out1 = (char *) malloc(1+strlen(in1)+strlen(in2));
    char* out2 = (char *) malloc(1+strlen(out1)+strlen(in3));
    strcpy(out1, in1);
    strcat(out1, in2);

    strcpy(out2, out1);
    strcat(out2, in3);

    return out2;

}