#ifndef _SIM5320_H_
#define _SIM5320_H_

#include "mbed.h"
#include <string>


#define BUFFER_SIZE 512

class SIM5320 {
private:      
 char* concatChars(const char* in1, const char* in2, const char* in3);
 void rxInterrupt();
public:
  SIM5320();
  SIM5320(PinName tx, PinName rx, bool debug = false); 
  string readBuffer();
  Serial SIM5320Serial; 
  Serial debugSerial; 
  char rx_buffer[BUFFER_SIZE];
  void flushBuffer();
  int rx_in; 

  bool connect(const char *apn, const char *userName, const char *passPhrase);
  bool disconnect();
  bool enableGPS(bool isEnabled);
  
  string sendCommand(const char *command, uint8_t timeout = 20);           
  uint8_t sendCommandAndCheck(const char *command, const char *response, uint8_t timeout = 20);  

  void printDebug(const char *line);

};
#endif