#ifndef _SENSORBOARDS_H
#define _SENSORBOARDS_H
#include "mbed.h"

#define SENSOR_NUMBERS 0xA1
#define SENSORS_IDS 0xA2
#define SENSOR_READINGS 0xA3
#define Device_Name_ADDR   (0xEE) // Device You Wish to Use Address - using i2c Address
#define WRITE              (0x00) // i2c Write bit
#define READ               (0x01) // i2c Read bit


struct Board
{
	uint8_t I2CAddress;
	uint8_t sensorIDs[8];
	uint8_t numberOfSensors;
};

class SensorBoards
{
public:
	SensorBoards() : numberOfBoards(0) {} 
	uint8_t sensorBoardScanner();
	uint8_t sensorIDScanner();
	uint8_t getSensorNumbers();
	uint8_t getSensorIDs();
	void getSensorReadings(uint8_t address, uint8_t ID, uint8_t *IDMeasure);
	uint8_t returnBoardAdd();
//private:
	Board boards[8];
	int numberOfBoards;
};

#endif