#include <DeviceEmpty.h>
#include <DeviceFull.h>
#include <CaseFsm.h>



DeviceFull::DeviceFull(CaseFsmStates& states, Timer& timer) : CaseState(states,timer)
{
}

CaseState* DeviceFull::handle(SwitchPosition& event)
{
    printf("Odoh u DEVICE EMPTY STATE\r\n");
    return states_.deviceEmptyState();
}



CaseState* DeviceFull::handle(RFIDEvent& event)
{
    int count=0;
    uint8_t tag[]= {0xDB,0x6C,0x10,0x2B};
    //printf("%d\r\n",event.cardType);
    for(int i=0; i<event.size; i++) {
        if(tag[i]==event.uid[i]) {
      //      printf(" %x  count=%d",event.uid[i], count);
            count++;
        }
    }
        
       //printf(" count %d\r\n",count);
        
        if(count==4) { //Je li to validan TAG
        printf("Odoh u PHONE DETECTED STATE\r\n");
           
            return states_.phoneDetectedState();  //TAG je validan idem u detected
            
        } else {
             printf("Odoh u PHONE UNDETECTED STATE\r\n");
            return states_.phoneUndetectedState(); //Ako nije idem u undetected
            
        }
}
CaseState* DeviceFull::handle(TimerEnd& event)
{
    printf("Odoh u DEVICE UNDETECTED STATE\r\n");
    return states_.phoneUndetectedState();
}


