#include <DeviceEmpty.h>
#include <DeviceFull.h>
#include <PhoneUndetected.h>
#include <PhoneDetected.h>
#include <CaseFsm.h>

CaseFsmStates::CaseFsmStates() : deviceEmptyState_(new DeviceEmpty(*this,timer)),
    deviceFullState_(new DeviceFull(*this,timer)),
    phoneUndetectedState_(new PhoneUndetected(*this,timer)),
    phoneDetectedState_(new PhoneDetected(*this,timer))
{
    currentState(deviceEmptyState());
}


CaseState* CaseFsmStates::deviceEmptyState()
{
    return deviceEmptyState_;
}

void CaseFsm::timerCallback(){
    printf("Odoh u DEVICE EMPTY STATE\r\n");
    states_.currentState(states_.deviceEmptyState());
    }

CaseState* CaseFsmStates::deviceFullState()
{
    return deviceFullState_;
}
CaseState* CaseFsmStates::phoneUndetectedState()
{
    return phoneUndetectedState_;
}
CaseState* CaseFsmStates::phoneDetectedState()
{
    return phoneDetectedState_;
}

CaseState* CaseFsmStates::currentState()
{
    return currentState_;
}
void CaseFsmStates::currentState(CaseState* state)
{
    currentState_ = state;
}

CaseFsmStates::~CaseFsmStates()
{
    delete deviceEmptyState_;
    delete deviceFullState_;
    delete phoneUndetectedState_;
    delete phoneDetectedState_;
}

CaseFsm::CaseFsm() : states_()
{


}



