#include <Moving.h>
#include <Stacionary.h>
#include <Fsm.h>

FsmStates::FsmStates() : movingState_(new Moving(*this,timer)),
    stacionaryState_(new Stacionary(*this,timer))
{
    currentState(stacionaryState());
}



State* FsmStates::stacionaryState()
{
    return stacionaryState_;
}

State* FsmStates::movingState()
{
    return movingState_;
}

State* FsmStates::currentState()
{
    return currentState_;
}
void FsmStates::currentState(State* state)
{
    currentState_ = state;
}

FsmStates::~FsmStates()
{
    delete stacionaryState_;
    delete movingState_;
}

Fsm::Fsm() : states_()
{


}



