#include  "LinearMotion.h"
#define STEPS_PER_PIXEL 100

void LinearMotion::setStepMotors(Stepper * s1, Stepper * s2, Stepper * s3, DigitalOut * solenoid) {
    _sol = solenoid;
    StepMotor[0] = s1;
    StepMotor[1] = s2;
    StepMotor[2] = s3;
}

void LinearMotion::interpolate(Vector length, int maxSpeed) {
    interpolate(length, maxSpeed, false);
}

void LinearMotion::interpolate(Vector length, int maxSpeed, bool solenoidOn) {
    long tempLength;
    Stepper * tempStep;
        
    Stepper * reorderedStepMotor[3];
    reorderedStepMotor[0] = StepMotor[0];
    reorderedStepMotor[1] = StepMotor[1];
    reorderedStepMotor[2] = StepMotor[2];
    if (abs(length.y) > abs(length.x)) {
        tempLength = length.y;
        length.y = length.x;
        length.x = tempLength;
        tempStep = reorderedStepMotor[1];
        reorderedStepMotor[1] = reorderedStepMotor[0];
        reorderedStepMotor[0] = tempStep;
    }
    if (abs(length.z) > abs(length.x)) {
        tempLength = length.z;
        length.z = length.x;
        length.x = tempLength;
        tempStep = reorderedStepMotor[2];
        reorderedStepMotor[2] = reorderedStepMotor[0];
        reorderedStepMotor[0] = tempStep;
    }    
    
    enableSteppers(true);
    doLinear(length, reorderedStepMotor, maxSpeed, solenoidOn);
    enableSteppers(false);
}

void LinearMotion::interpolateSquare(Vector basePos, Vector heightPos, int maxSpeed, bool solenoidOn) {
    long tempLength;
    Stepper * tempStep;
        
    Stepper * reorderedStepMotor[3];
    reorderedStepMotor[0] = StepMotor[0];
    reorderedStepMotor[1] = StepMotor[1];
    reorderedStepMotor[2] = StepMotor[2];
    if (abs(heightPos.y) > abs(heightPos.x)) {
        tempLength = heightPos.y;
        heightPos.y = tempLength;
        heightPos.x = tempLength;
        tempStep = reorderedStepMotor[1];
        reorderedStepMotor[1] = reorderedStepMotor[0];
        reorderedStepMotor[0] = tempStep;
    }
    if (abs(heightPos.z) > abs(heightPos.x)) {
        tempLength = heightPos.z;
        heightPos.z = heightPos.x;
        heightPos.x = tempLength;
        tempStep = reorderedStepMotor[2];
        reorderedStepMotor[2] = reorderedStepMotor[0];
        reorderedStepMotor[0] = tempStep;
    }    
    
    enableSteppers(true);
    doLinearSideways(heightPos, basePos, reorderedStepMotor, maxSpeed, solenoidOn);
    Vector homePosition;
    homePosition.x = -(heightPos.x);
    homePosition.y = -(heightPos.y);
    homePosition.z = -(heightPos.z);
    interpolate(homePosition, maxSpeed);
    enableSteppers(false);
    
}

void LinearMotion::doLinearSideways(Vector delta, Vector nextRow, Stepper ** stepMotor, int maxSpeed, bool solenoidOn) {
    int fxy,fxz;
    Vector lastRow, dir;
    lastRow.x = -nextRow.x;
    lastRow.y = -nextRow.y;
    lastRow.z = -nextRow.z;
    
    if(delta.x < 0)
        dir.x = 0; //towards motor
    else
        dir.x = 1; //away from motor
    if(delta.y < 0)
        dir.y = 0; //towards motor
    else
        dir.y = 1; //away from motor
    if(delta.z < 0)
        dir.z = 0; //towards motor
    else
        dir.z = 1; //away from motor
    delta.x = abs(delta.x);
    delta.y = abs(delta.y);
    delta.z = abs(delta.z);
    fxy = delta.x - delta.y;
    fxz = delta.x - delta.z;
        
    Vector currentPos;
    currentPos.x = 0;
    currentPos.y = 0;
    currentPos.z = 0;
    
    while((currentPos.x<=delta.x)&&(currentPos.y<=delta.y)&&(currentPos.z<=delta.z)){
        ++currentPos.x;
         ///printf("Moving height: %d, %d, %d\n\r", currentPos.x, currentPos.y, currentPos.z);
        if((currentPos.x % STEPS_PER_PIXEL) == 0) {
            interpolate(nextRow, maxSpeed, solenoidOn);
            interpolate(lastRow, maxSpeed, false);
        }
        stepMotor[0]->stepOn(dir.x);
        fxy -= delta.y;
        fxz -= delta.z;
        if(fxy <= 0){
            ++currentPos.y;
            stepMotor[1]->stepOn(dir.y);
            fxy += delta.x;
        }
        if(fxz <= 0){
            ++currentPos.z;
            stepMotor[2]->stepOn(dir.z);
            fxz += delta.x;
        }
        wait_us(1);
        stepMotor[0]->stepOff();
        stepMotor[1]->stepOff();
        stepMotor[2]->stepOff();
        wait_us(maxSpeed);  //Implement linear accelleration!
    }
}

void LinearMotion::doLinear(Vector delta, Stepper** stepMotor, int maxSpeed, bool solenoidOn) {
    int fxy,fxz;
    Vector dir;
    
    if(delta.x < 0)
        dir.x = 0; //towards motor
    else
        dir.x = 1; //away from motor
    if(delta.y < 0)
        dir.y = 0; //towards motor
    else
        dir.y = 1; //away from motor
    if(delta.z < 0)
        dir.z = 0; //towards motor
    else
        dir.z = 1; //away from motor
    delta.x = abs(delta.x);
    delta.y = abs(delta.y);
    delta.z = abs(delta.z);
    fxy = delta.x - delta.y;
    fxz = delta.x - delta.z;
        
    Vector currentPos;
    currentPos.x = 0;
    currentPos.y = 0;
    currentPos.z = 0;
    
    while((currentPos.x<=delta.x)&&(currentPos.y<=delta.y)&&(currentPos.z<=delta.z)){
        ++currentPos.x;
//        printf("Moving base: %d, %d, %d,, %d, %d\n\r", currentPos.x, currentPos.y, currentPos.z, delta.x, delta.y);
        if(solenoidOn && (currentPos.x % STEPS_PER_PIXEL == 0)) {
            *_sol = !(*_sol);
        }
        stepMotor[0]->stepOn(dir.x);
        fxy -= delta.y;
        fxz -= delta.z;
        if(fxy <= 0){
            ++currentPos.y;
            stepMotor[1]->stepOn(dir.y);
            fxy += delta.x;
        }
        if(fxz <= 0){
            ++currentPos.z;
            stepMotor[2]->stepOn(dir.z);
            fxz += delta.x;
        }
        wait_us(1);
        stepMotor[0]->stepOff();
        stepMotor[1]->stepOff();
        stepMotor[2]->stepOff();
        wait_us(maxSpeed);  //Implement linear accelleration!
    }
}
      
void LinearMotion::enableSteppers(bool en) {
    StepMotor[0]->enable(en);
    StepMotor[1]->enable(en);
    StepMotor[2]->enable(en);
}
