// Display Test
#include "mbed.h"
#include "KS0108.h"
#include "calsolimage.h"
#include "numbers.h"


KS0108 display(p23,p21,p22,p20,p24,p25,p17,p18,p19,p30,p29,p28,p27,p26);
DigitalIn topButton(p13);
DigitalIn bottomButton(p12);
Serial pc(USBTX,USBRX);
Timer timer1;
Timer timer2;

void rules (unsigned char *);
void random (unsigned char *);

int main() {
  int dist = 20;
  int demo = 0;
  int i = 0;
  topButton.mode(PullUp);
  bottomButton.mode(PullUp);
  display.FullScreenBMP(pic);
  wait(0.2);

  timer1.start();
  timer2.start();
  while(1) {
    if(!topButton) {
      if(timer1.read_ms() > 200) {
        demo++;
        display.ClearScreen();
        if(demo > 3) {
          demo = 0;
        }
        timer1.reset();
      }
    }
    switch(demo) {
    case 0:
      if(timer2.read_ms() > 500) {
        rules(pic);
        display.FullScreenBMP(pic);
        timer2.reset();
      }
      break;
    case 1:
      display.ClearScreen();
      break;
    case 2:
      if(timer2.read_ms() > 100) {
        // display.PutString(3,2,"I can has mbed too");
       //  display.PrintFloat(123.23,4,5);
         display.VLine(6+i,47,56,BLACK);
         if (i < 10){dist = 30;}
         else if (i < 100){dist = 25;}
         else {dist = 20;}         
         display.PrintInteger(i,6,dist);
         i++;
         if(i > 100) {
           i = 0;
           display.ClearScreen();
         }
         timer2.reset();
      }
      break;
    case 3:
      if(timer2.read_ms() > 500) {
        rules(pic);
        display.FullScreenBMP(pic);
        timer2.reset();
      }
k,    default:
      break;
    }
  }
}

void rules (unsigned char * array) {
  char neighborArray[128][64];
  // Get number of neighbors
  for (int x = 0; x < 128; x++) {
    for (int y = 0;y < 64; y++) {
      neighborArray[x][y] = 0;
    }
  }
  for (int y = 0;y < 64; y++) {
    for (int x = 0; x < 128; x++) {
      if (array[x + (y/8*8)*16] & (1<<(y%8))) {
        if (x != 0) {
          neighborArray[x-1][y] += 1;
          if (y != 0) {
            neighborArray[x-1][y-1] += 1;
          }
          if (y != 127) {
            neighborArray[x-1][y+1] += 1;
          }
        }
        if (x != 127) {
          neighborArray[x+1][y] += 1;
          if (y != 0) {
            neighborArray[x+1][y-1] += 1;
          }
          if (y != 127) {
            neighborArray[x+1][y+1] += 1;
          }
        }
        if (y != 0) {
          neighborArray[x][y-1] += 1;
        }
        if (y != 63){
          neighborArray[x][y+1] += 1;
        }
      }
    }
  }
  int arrayIndex;
  for (int y = 0;y < 64; y++) {
    for (int x = 0; x < 128; x++) {
      arrayIndex = x + (y/8*8)*16;
      if (neighborArray[x][y] == 3) {
        array[arrayIndex] |= (1<<(y%8));
      } else if (neighborArray[x][y] == 2) {
        continue;
      } else {
        array[arrayIndex] &= ~(1<<(y%8));
      }
    }
  }
}

void random (unsigned char * array) {
  for (int y = 0;y < 64; y += 8) {
    for (int x = 0; x < 128; x++) {
      array[x + y*16] = (unsigned char) rand();
    }
  }
}