#include "Bitmap.h"
//Hi!
#define OFFSET_LOCATION 0x0a
#define WIDTH_LOCATION 0x12
#define HEIGHT_LOCATION 0x16

bool Bitmap::isPixel(int pixel) {
    if (pixel > width) { return false; }
    if ((row_data[pixel/32]>>(pixel%32)) & 0x01) { return false; }
    else { return true; }
}

Bitmap::Bitmap () {
    loaded = false;
    fp = NULL;
    row_data = NULL;
}

bool Bitmap::openImg(char* filename) {
    if (fp != NULL) {
        fclose(fp);
        free(row_data);
    }
    fp = fopen(filename, "rb");
    loaded = true;
    fseek(fp, OFFSET_LOCATION, SEEK_SET);
    fread((char *) &offset, 1, 4, fp);
    fseek(fp, WIDTH_LOCATION, SEEK_SET);
    fread((char *) &width, 1, 4, fp);
    fread(&height, sizeof(long), 1, fp);
    fseek(fp, HEIGHT_LOCATION, SEEK_SET);
    row_size = (width % 32) ? (width / 32) + 1 :  width / 32;
    row_data = (long *) malloc(row_size * sizeof(long));
    return true;
}

bool Bitmap::setRow(int row) {
    if (loaded) {
        row_num = row;
        fseek(fp, offset + row * row_size*sizeof(long), SEEK_SET);
        for (int i = 0; i < row_size; i++) {
            fread(row_data + i, sizeof(long), 1, fp);
        }
        return true;
    } else {
        return false;
    }
}

bool Bitmap::closeImg(void) {
    fclose(fp);
    free(row_data);
    return true;
}

int Bitmap::getHeight() {
    return height;
}

int Bitmap::getWidth() {
    return width;
}
 