/**********************************************************************************
* @file    main.cpp
* @author  Marta Krepelkova
* @version V0.1
* @date    26-April-2015
* @brief   LED blinking with microcontroller in a small package (TSSOP20), 4kB RAM
*          Modified mbed-library.
*          DO NOT FORGET TO SELECT NUCLEO-F030R8 AS YOUR MBED PLATFORM!
***********************************************************************************/
 
/**********************************************************************************/
/*   Table of used pins on STM32F0 Discovery kit with STM32F031F6P6 MCU (TSSOP20) */
/**********************************************************************************/
/*  TSSOP20 pin     |     peripheral                                              */
/*   11 (PA_5)      |     LED                                                     */
/**********************************************************************************/
 
/* Includes ----------------------------------------------------------------------*/
#include "mbed.h"

/* Defines -----------------------------------------------------------------------*/
 
/* Function prototypes -----------------------------------------------------------*/
 
/* Variables ---------------------------------------------------------------------*/

// mbed - initialization of peripherals
DigitalOut myled_ext(PA_5); // LED is connected to PA_5
DigitalOut myled_onb(PA_4); // LED is connected to PA_4 onboard
/* Functions----------------------------------------------------------------------*/

/***********************************************************************************
* Function Name  : main.
* Description    : Main routine.
* Input          : None.
* Output         : None.
* Return         : None.
***********************************************************************************/
int main() {
    while(1) {
        myled_ext = 1; // LED is OFF (we have connected it to VCC)

        myled_onb = 0;
        wait(0.1); // 200 ms
        myled_onb = 1;
        wait(0.1); // 200 ms
        myled_onb = 0;
        wait(0.1); // 200 ms
        myled_onb = 1;
        wait(0.1); // 200 ms
        myled_onb = 0;
        wait(1.0); // 200 ms

        myled_ext = 0; // LED is On
        myled_onb = 1;
        wait(2.0); // 1 sec
    }
}
