/** mbded library for driving the MCP9808 Temperature sensor
* datasheet link : http://ww1.microchip.com/downloads/en/DeviceDoc/25095A.pdf
* breakout       : Adafruit MCP9808 Breakout board
* Christoph Suter (code based on Richard Kadrmas Nucleo-MCP9808 sample)
*/


#include "mbed.h"


#ifndef MBED_DS3231_H
#define MBED_DS3231_H
//MCP9808 8 bit adress
#define MCP9808_ADDR     (0x30) // MCP9808 base address 0x18<<1

#define MCP9808_REG_TEMP (0x05) // Temperature Register
#define MCP9808_REG_CONF (0x01) // Configuration Register

/* Interface to MAXIM DS3231 RTC */
class MCP9808
    {public :
     /** Create an instance of the MCP9808 connected to specfied I2C pins
     *
     * @param sda The I2C data pin
     * @param scl The I2C clock pin
     */
     MCP9808(PinName sda, PinName scl);
     
     /** Read the temperature
     *
     * @return The temperature
     */
     float readTemp();
     
     /** Go to sleep
     */
     void goSleep();
     
     /** Wake up
     */
     void wakeUp();
     
     
     private :
     I2C i2c;
     char data_write[3];
     char data_read[2];
     float tempval;
     };
     
#endif