#include "MCP9808.h"

MCP9808::MCP9808(PinName sda, PinName scl) : i2c(sda, scl)
    {
    } 
     
// read temperature from MCP9808    
float MCP9808::readTemp()
    {
        data_write[0] = MCP9808_REG_TEMP;
        i2c.write(MCP9808_ADDR, data_write, 1, 1); // no stop
        i2c.read(MCP9808_ADDR, data_read, 2, 0);
 
        if(data_read[0] & 0xE0) {
            data_read[0] = data_read[0] & 0x1F;  // clear flag bits
        }
        if((data_read[0] & 0x10) == 0x10) { // < 0 C
            data_read[0] = data_read[0] & 0x0F;
            tempval = 256 - (data_read[0] * 16) + (data_read[1] / 16.0);
            tempval = tempval * -1;
        } else { // > 0 C
            tempval = (data_read[0] * 16) + (data_read[1] / 16.0);
        }
        return tempval;
        }  

void MCP9808::goSleep()
{
    data_write[0] = MCP9808_REG_CONF;
    data_write[1] = 0x01;  // config msb
    data_write[2] = 0x00;  // config lsb
    int status = i2c.write(MCP9808_ADDR, data_write, 3, 0);    
    }
    
void MCP9808::wakeUp()
{
    data_write[0] = MCP9808_REG_CONF;
    data_write[1] = 0x00;  // config msb
    data_write[2] = 0x00;  // config lsb
    int status = i2c.write(MCP9808_ADDR, data_write, 3, 0);    
    }