#include <mbed.h>

// WEB Server to control one LED
// -----------------------------

Serial pc(USBTX, USBRX);
Serial esp(PA_9, PA_10);    // tx, rx 
DigitalOut  sw(PA_5);       // Change LED to a pin of your choice. However, make sure that it does not collide with any serial pins already used

Timer t;

int  count,ended,timeout;
char buf[1024];
char snd[255];

const char* PASSWORD = "secret";        // change as you like
const char ssid[32] = "ESP8266";        // enter router ssid inside the quotes
const char pwd [32] = "ok";             // enter router password inside the quotes
char http[1024];                        // HTTP content
uint8_t port = 80;
int id = 1;

void SendCMD(char*),SendData(char*),GetReplyLine(int,char*,int),GetReply(int,char*,int),ESPconfig_Server(),ESPconfig_Client(),ESPsetbaudrate(),page(int);
int checksw(char*);


// USAGE:
//       IP/password
//       IP/password/?sw=1 
//       IP/password/?sw=0 


int main()
{

    // Setup    
    esp.baud(115200);  // esp speed
    pc.baud(9600);     // change this to the new ESP8266 baudrate if it is changed at any time.    
    

    //ESPconfig_Client();        
    ESPconfig_Server();    
        
    for (int i=0; i<8; i++)
    {
        sw=!sw;
        wait(0.3);
    }
       
    
    // Loop
    while(1) {
        timeout=2;
        if(esp.readable()){         
            GetReply(500,buf,sizeof(buf));  
            char* rqstPnt = strstr(buf, "+IPD");
            if(rqstPnt != NULL)
            {
                sscanf(rqstPnt, "+IPD,%d", &id);
                
                page(checksw(buf));
                         
                // Command TCP/IP Data Tx
                sprintf(snd,"AT+CIPSEND=%d,%d\r\n", id, strlen(http));
                SendCMD(snd);
                GetReply(500,buf,sizeof(buf));  
                
                SendData(http);
                     
                bool weberror = true;
                int cnt = 0;
                while(weberror && cnt < 100){
                    GetReply(500,buf,sizeof(buf));  
                    if(strstr(buf, "SEND OK") != NULL) 
                        weberror = false;
                
                    cnt++;
                }
                        
                if(weberror)
                {
                    strcpy(snd,"AT+CIPMUX=1\r\n");
                    SendCMD(snd);
                    GetReply(500,buf,sizeof(buf));  
    
                    sprintf(snd,"AT+CIPSERVER=1,%d\r\n", port);
                    SendCMD(snd);
                    GetReply(2000,buf,sizeof(buf));  
                }
                else
                {
                    sprintf(snd,"AT+CIPCLOSE=%d\r\n", id);  // Notice id is an int formatted to string
                    SendCMD(snd);
                    GetReply(500,buf,sizeof(buf));  
                }
            }
        }
    }
}


void page(int status)
{
    char content_length[5];
    char info[255];
    
    strcpy(info,"<h2>Web Switch</h2>\r\n");

    if(status < 0) 
    {
        strcat(info,"<p>Usage: http://host_or_ip/password</p>\r\n");   
    }
    else if (status == 1)
    {
        strcat(info,"<pre>\r\n  <font color=#FF0000>ON</font>");
        strcat(info," <a href=\"./?sw=0\">[switch off]</a>\r\n");
    } 
    else 
    {
        strcat(info,"<pre>\r\n  <font color=#00FF00>OFF</font>");
        strcat(info," <a href=\"./?sw=1\">[switch on]</a>\r\n");
    }

    strcat(info,"  <a href=\".\">[refresh status]</a>\r\n");
    strcat(info,"</pre>\r\n");
    strcat(info,"<br>\r\n");
    
    strcpy(http,"HTTP/1.0 200 OK");
    strcat(http,"\r\nContent-Type: text/html\r\n");   
    strcat(http,"Content-Length: ");
    sprintf(content_length, "%d", strlen(buf));
    strcat(http,content_length);
    strcat(http,"\r\nPragma: no-cache\r\n");
    strcat(http,"Connection: About to close\r\n\r\n");
    strcat(http,info);
}


int checksw(char *buf)
{
    int ret = 0;
    
    if(strstr(buf,PASSWORD)== NULL)
        return -1;
 
     char* rqstPnt = strstr(buf, "?sw=");
     if(rqstPnt == NULL)
        ret = 0;  
     else  
        sscanf(rqstPnt,"?sw=%d", &ret);
       
     if(ret == 1)
        sw = 1;     // switch on
     else
        sw = 0;    // switch off 
       
     return  ret;             
}


void ESPconfig_Server()
{

    pc.printf("------- Starting ESP Config -------\r\n\n");
    pc.printf("------- Reset & get Firmware ------\r\n");
    strcpy(snd,"AT+RST\r\n");
    SendCMD(snd);
    GetReply(6000,buf,sizeof(buf));  
      
   
    pc.printf("\n---------- Get Version ----------\r\n");
    strcpy(snd,"AT+GMR\r\n");
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf));  
    pc.printf(buf);  
    GetReply(1000,buf,sizeof(buf));  
            
    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "AT+CWMODE=2\r\n");
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf));  
    pc.printf(buf);    
    
    // set CIPMUX to 0=Single,1=Multi 
    pc.printf("\n---- Setting Connection Mode -----\r\n");
    strcpy(snd, "AT+CIPMUX=1\r\n"); 
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf)); 
    
    
     
    pc.printf("\n------------  AP ------------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWSAP=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\",4,0\r\n");   
    SendCMD(snd);
    GetReply(8000,buf,sizeof(buf));     
    pc.printf(buf);  
  
    pc.printf("\n------- Set Server Port ------\r\n");
    sprintf(snd, "AT+CIPSERVER=1,%d\r\n", port);
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf));    
        
        
    pc.printf("\n----- Set Server Timeout -----\r\n");
    sprintf(snd,"AT+CIPSTO=%d\r\n", 5);
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf)); 
     
    
    pc.printf("\n---------- Get IP's ----------\r\n"); 
    strcpy(snd, "AT+CWSAP?\r\n"); 
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf));   
    pc.printf(buf);
    
    strcpy(snd, "AT+CIFSR\r\n");
    SendCMD(snd);
    GetReply(2000,buf,sizeof(buf)); 
    pc.printf(buf);          
    pc.printf("\n------- Connection Up --------\r\n"); 
 
} 

void ESPconfig_Client()
{

    pc.printf("---------- Starting ESP Config -----------\r\n\n");
    pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"AT+RST\r\n");
    SendCMD(snd);
    GetReply(6000,buf,sizeof(buf));  
      
   
    pc.printf("\n---------- Get Version ----------\r\n");
    strcpy(snd,"AT+GMR\r\n");
    SendCMD(snd);
    GetReply(3000,buf,sizeof(buf));  
    pc.printf(buf);  
        
    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "AT+CWMODE=1\r\n");
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf));  
    
    
    // set CIPMUX to 0=Single,1=Multi 
    pc.printf("\n-------- Setting Connection Mode ---------\r\n");
    strcpy(snd, "AT+CIPMUX=1\r\n"); 
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf)); 
    
    
    pc.printf("\n---------- Listing Acces Points ----------\r\n");
    strcpy(snd, "AT+CWLAP\r\n");
    SendCMD(snd);
    GetReply(3000,buf,sizeof(buf));      
    pc.printf(buf);      
    
    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");   
    SendCMD(snd);
    GetReply(8000,buf,sizeof(buf));     
    pc.printf(buf);  
  
    pc.printf("\n------ Set Server Port -------\r\n");
    sprintf(snd, "AT+CIPSERVER=1,%d\r\n", port);
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf));    
        
        
    pc.printf("\n----- Set Server Timeout -----\r\n");
    sprintf(snd,"AT+CIPSTO=%d\r\n", 5);
    SendCMD(snd);
    GetReply(1000,buf,sizeof(buf)); 
     
    
    pc.printf("\n---------- Get IP's ----------\r\n"); 
    int weberror = true;
    while(weberror) {  // wait for valid IP
        strcpy(snd, "AT+CIFSR\r\n");
        SendCMD(snd);
        GetReply(2000,buf,sizeof(buf)); 
        pc.printf(buf);
        if(strstr(buf, "0.0.0.0") == NULL) {
                weberror=false;   
        }
    }    
            
    pc.printf("\n------- Connection Up --------\r\n"); 
 
} 

void SendCMD(char *cmd)
{    
    esp.printf("%s", cmd);    
} 

void SendData(char *dat)
{    
    esp.printf("%s", dat);    
} 

void GetReply(int timeout, char *buf, int size)
{    
    char c;
    ended=0;
    count=0;
    t.start();
    memset(buf, '\0', size);   
    while(!ended) {
        if(esp.readable()) {         
            c = esp.getc();
                  
            buf[count] = c;
            count++;
            
            if (c == '\r' || c == '\n') // OK will end
            {
                if (count > 2 && buf[count-3]== 'O' && buf[count-2] == 'K')
                {
                    buf[count-1] = '\r';
                    buf[count] = '\n';
                    count = size;
                }
            }
        }
        
        if(t.read_ms() > timeout || count >= size) // Timeout or full
        {
            ended = 1;
            t.stop();
            t.reset();
        }
    }  
    //pc.printf(buf);
}              

