#include "mbed.h"
#include "usb.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------


#define PULSE_WIDTH 1000
#define ONE_DELAY   10000
#define ZERO_DELAY  40000

DigitalOut myled(LED1);
DigitalOut outpin(D15);
void transmit_bit(char c) {
    int i;
    for (i = 0; i < 8; i++) {
        myled = 1;
        outpin = 1;
        wait_us(PULSE_WIDTH);
        myled = 0;
        outpin = 0;
        if (c & 0x1) {
            wait_us(ONE_DELAY);
        } else {
            wait_us(ZERO_DELAY);
        }
        c >>= 1;
    }
}

void transmit(char * data, unsigned int size) {
    int i;
    for (i = 0; i < size; i++) {
        transmit_bit(data[i]);
    }
}

int main() {
  myled = 1;
  outpin = 1;
  int i = 0;
  usb_write("Hello World !\n");
  while(1) {
      myled = 1;
      outpin = 1;
      i = 0;
      wait(1);
      char * str = "This program is alive \n";
      usb_write(str);
      transmit("Hello", 5);
  }
}

