//
//==============================================================================
//Include mbed header file which contains the definition of DigitalOut class. 
#include "mbed.h"
//Include TextLCD header file which contains the definition of TextLCD class. 
#include "TextLCD.h"
#define __IRC_OSC_CLK     (12000000UL)
//==============================================================================

DigitalOut ld_1(dp14);
DigitalOut ld_2(dp28);
//------------------------------------------------------------------------------
AnalogIn canal_0 (dp9);

//==============================================================================
//Initialize TextLCD with the correct pins
//TextLCD_I2C lcd(&i2c_lcd, 0x42, TextLCD::LCD20x4); // I2C bus, PCF8574 Slaveaddress, LCD Type
//TextLCD_I2C lcd(&i2c_lcd, 0x42, TextLCD::LCD16x2, TextLCD::WS0010); // I2C bus, PCF8574 addr, LCD Type, Ctrl Type
//..............................................................................
//SPI spi_lcd(p5, NC, p7); // MOSI, MISO, SCLK
//TextLCD_SPI lcd(&spi_lcd, p8, TextLCD::LCD24x4); // SPI bus, CS pin, LCD Type
//------------------------------------------------------------------------------
TextLCD lcd(dp17, dp18, dp1, dp2, dp6, dp4, TextLCD::LCD16x2); // rs, e, d4-d7, LCD Type
//            rs,    e,  d4-    d5-   d6-   d7,         LCD Type
//------------------------------------------------------------------------------
//==============================================================================
//..............................variaveis
char dezmilhar;
char milhar;
char centena;
char dezena;
char unidade;
unsigned short i;
unsigned short valor_adc;
//unsigned short temp;
//------------------------------------------------------------------------------

void converte_4_digitos(void);
void pisca_leds(void);
void alterna_leds(void);
void converte_adc(void);
//==============================================================================
//Main function
//------------------------------------------------------------------------------
int main() 
{ 
    //Clear the LCD display
    lcd.cls();
//------------------------------------------------------------------------------
    pisca_leds();
    wait(0.20);
    alterna_leds();
    wait(0.20);
//------------------------------------------------------------------------------
    //Locate Row 0 Column 0 in the LCD display
    lcd.locate(0, 0);
    //Print "The End"
    lcd.printf("CONTAGEM:");  
      
    //CONTA DE 0 A 2000 
    for(  i=0 ; i<=2000 ; i++)
    {
        //syntax Lcd.locate (coluna, linha) no  LCD display
        lcd.locate(0, 1);
        //Call PrintToLCD function
        lcd.printf("        ");
        lcd.locate(0, 1);
        lcd.printf("%f", canal_0.read());
        valor_adc = canal_0.read()*10000;
        converte_adc();
        //wait for 250ms
        converte_4_digitos();
           
        wait(0.25);
    }
//-----------------------------------------------------------------------------
    wait(3);
//-----------------------------------------------------------------------------
    //Clear the LCD display
    lcd.cls();
    //syntax Lcd.locate (coluna, linha) no  LCD display
    lcd.locate(0, 0);
    //Print "The End"
    lcd.printf("FIM !");
    //-------------------------------------------------------------------------
    pisca_leds();
//-----------------------------------------------------------------------------
    

//-----------------------------------------------------------------------------
}
//=============================================================================
//............................FIM DO PROGRAMA
//=============================================================================
//........................S U B _ R O T I N A S
//-----------------------------------------------------------------------------
//.......................................................
void converte_4_digitos(void){
   // milhar = (i /1000) % 10 ;
    milhar = (i /1000) ;
    centena = (i /100) % 10;
    dezena = (i/10) % 10;
    unidade = i % 10;
//-------------------------------------------------------
//.....syntax Lcd.locate (coluna, linha) no  LCD display  
//-------------------------------------------------------  
        lcd.locate(11, 0);
        lcd.printf("%d", milhar );
        
        lcd.locate(12, 0);
        lcd.printf("%d", centena );
        
        lcd.locate(13, 0);
        lcd.printf("%d", dezena );
        
        lcd.locate(14, 0);
        lcd.printf("%d", unidade );
        alterna_leds();
    }
//=============================================================================
void pisca_leds(void)
 {   
//-----------------------------------------------------------------------------
    ld_1 = 1;
    ld_2 = 1;
    wait(0.20);
//-----------------------------------------------------------------------------
    ld_1 = 0;
    ld_2 = 0;
//-----------------------------------------------------------------------------
}
//=============================================================================
//=============================================================================
void alterna_leds(void)
 {   
//-----------------------------------------------------------------------------
    ld_1 = 1;
    wait(0.05);
    ld_2 = 0;
    wait(0.10);
//-----------------------------------------------------------------------------
    ld_1 = 0;
    wait(0.05);
    ld_2 = 1;
    wait(0.10);
    
    ld_1 = 0;
    ld_2 = 0;
//-----------------------------------------------------------------------------
}
//=============================================================================
//.......................................................
void converte_adc(void){
   // milhar = (i /1000) % 10 ;
    dezmilhar = (valor_adc/10000);
    milhar = (valor_adc /1000)% 10 ;
    centena = (valor_adc /100) % 10;
    dezena = (valor_adc/10) % 10;
    unidade = valor_adc % 10;
//-------------------------------------------------------
//.....syntax Lcd.locate (coluna, linha) no  LCD display  
//-------------------------------------------------------  
        lcd.locate(11, 1);
        lcd.printf("%d", dezmilhar );
        
        lcd.locate(12, 1);
        lcd.printf("%d", milhar );
        
        lcd.locate(13, 1);
        lcd.printf("%d", centena );
        
        lcd.locate(14, 1);
        lcd.printf("%d", dezena );
        
        lcd.locate(15, 1);
        lcd.printf("%d", unidade );
        
        alterna_leds();
    }