#include "mbed.h"

DigitalOut led_red(LED_RED);
DigitalOut led_3(LED_BLUE);
DigitalOut led_2(LED_GREEN);
InterruptIn sw2(SW2);
InterruptIn sw1(PTA4);
Serial pc(USBTX, USBRX);
//==============================================================
//ASCII CHARACTER FOR "WAIT 2 SECONDS"
char hello[]={87,65,73,84,32,50,32,83,69,67,79,78,68,83,};
//--------------------------------------------------------------
//ASCII CHARACTER FOR "TIME OUT"
char msg_1[]={84,32,73,32,77,32,69,32,32,79,32,85,32,84,};

//==============================================================
 char contador ; 
 int temp_led;  

//--------------------------------------------------------------
//==============================================================
void sw1_release(void)
{
     
     pc.printf("\n");
     pc.printf("-------------------------------------------\n");
     pc.printf("-----------SW1 PRESSED: BARGRAPH-----------\n");
     pc.printf("-------------------------------------------\n"); 
     pc.printf("----------------PERCENTAGE-----------------\n");
     pc.printf("0--------25--------50--------75--------100\n");

     
     for(int i=0 ; i<=40 ; i++)
    {
        
        pc.printf("|");
        led_2 = !led_2;   
        wait(0.050);
    }
    pc.printf("\n");
    pc.printf("-------------------------------------------\n");   
}
//-------------------------------------------------------------
//==============================================================
void sw2_release(void)
   
{
    wait(.011); 
    contador = contador + 1;
    led_red = !led_red;
    temp_led = led_red;
    pc.printf("BUTTON SW2 PRESSED ");
//-----------------------------------------------------------
    if (contador < 2){
        pc.printf("%d",contador);
        pc.printf(" TIME");
        }
        else {   
    pc.printf("%d",contador);
    pc.printf(" TIMES");
    }
//----------------------------------------------------------- 
    pc.printf("\n");
    
//-----------------------------------------------------    
    if (temp_led == 1) {
    pc.printf("LED RED OFF"); 
    pc.printf("\n");
    }
    else {
    pc.printf("RED LED ON"); 
    pc.printf("\n");
    } 
//------------------------------------------------------------------
     pc.printf("-------------------------------------------\n");
     pc.printf("    CHART HOW MANY TIMES WAS PRESSED SW2   \n");
     
     pc.printf("----------------PERCENTAGE-----------------\n");
     pc.printf("0--------25--------50--------75--------100\n");
    for(int i=1 ; i<=contador ; i++)
    {
        
        pc.printf("|");
        
        wait(0.050);
    }
    pc.printf("\n");
    pc.printf("-------------------------------------------\n"); 
    pc.printf("===========================================\n");    
//------------------------------------------------------------------
    led_3 = 0;
    pc.printf("LED BLUE ON [TWO SECONDS]"); 
    pc.printf("\n");
//------------------------------------------------------------------

    for(char i=0 ; i<=13 ; i++)
    {
        wait(2.0/10);
        pc.printf("%c",hello[i]);           
        wait(2.0/10);
    }
//------------------------------------------------------------------
    pc.printf("\n");
//------------------------------------------------------------------
for(char i=0 ; i<=13 ; i++)
    {
        wait(2.0/10);
        pc.printf("%c",msg_1[i]);           
        wait(2.0/10);
    }
//------------------------------------------------------------------
    pc.printf("\n");
    pc.printf("===========================================\n");

    led_3 = 1;
    if (contador > 40){
        contador = 0;
        pc.printf("*******************************************\n");
        pc.printf("       COUNTER RESET, START NEW CYCLE      \n");
        pc.printf("*******************************************\n");
        }
    
}
//-----------------------------------------------------------------------

//------------------------------------------------------------------------
int main()

{
    
    pc.baud(115200);
    led_3 = 1;
    wait(2.0);
    pc.printf("-------------------------------------------\n"); 
    pc.printf("**             SERIAL ENABLED!           **\n");
    pc.printf("-------------------------------------------\n");
    pc.printf("*        TEST PROGRAM BOARD FRDM-K64F     *\n");
    pc.printf("-------------------------------------------\n");
    pc.printf("*        120MHz, 256KB RAM, 1MB FLASH     *\n");
    pc.printf("-------------------------------------------\n");
    pc.printf("*        PRESS SW2: CONTROL RED LED       *\n");
    pc.printf("-------------------------------------------\n");
    pc.printf("*       PRESS SW1: SHOW GRAPHIC BARS      *\n");
    pc.printf("-------------------------------------------\n");
    pc.printf("*         MBED COMPILER [21/03/2015]      *\n");
    pc.printf("-------------------------------------------\n");
    pc.printf("===========================================\n");
    pc.printf("\n");
    pc.printf("\n");
    sw2.rise(&sw2_release);
    sw1.rise(&sw1_release);
    while (true) {
    }
}
