#include "application.h"
#include "mbed.h"

extern Serial pc;

float readTMP102Temperature(I2C& i2c, char* reg) {
    const char regAddr = TMP102_TEMP_REG_ADDR;
    i2c.write(TMP102_ADDR, &regAddr, 1);
    int result = i2c.read(TMP102_ADDR, reg, 2);
    if (result != 0)
        return -1;
    
    int TemperatureSum = (reg[0] << 8 | reg[1]) >> 4;
    return (float)TemperatureSum*0.0625;
}

/* AT24C64D */
bool writeAT24EEPROMBuffer(I2C& i2c, uint8_t dataAddr, char* buf, uint16_t length){
    uint8_t tmpBuf[10] = {0,};
    tmpBuf[0] = dataAddr;
    if(length > 9)
        length = 9;
        
    for(int i = 1; i < (length+1); i++)
        tmpBuf[i] = buf[i-1];
    
    int result = i2c.write(EEPROM_ADDR, (char*)tmpBuf, length+1);
    if (result != 0)
        return false;
    else
        return true;
}

bool readAT24EEPROMBuffer(I2C& i2c, uint8_t dataAddr, char* buf, uint16_t length){
    int result = i2c.write(EEPROM_ADDR, (char*)&dataAddr, 1);
    if (result != 0)
        return false;
    
    result = i2c.read(EEPROM_ADDR, buf, length);
    if (result != 0)
        return false;
        
    return true;
}