// SmoothAnalogIn.h: Martyn Stopps / Taneli Holtta : 18-06-10

// Header file: included by other code so we what is available (the declaration)

// SmoothAnalogIn class that takes arguments PinName, adc sample rate, smoothing factor and scaling factor
// PinName: P15..20 (analogue inputs)
// adc sampling rate: duration in seconds ie 0.01 = 100Hz (a ticker in the class takes care of sampling)
// smoothing factor: 1 to x (smoothed value +-difference)/x
// scaling factor: adc returns float O to 1 representing 0  to 3.3V) ie a scaling factor of 3300 returns actual adc input in mV 

// To use the class
// #include "SmoothAnalogIn.h" in main.cpp           // include SmoothAnalogIn header file
// SmoothAnalogIn tc1(p15,0.01,5,3300);              // (PinName, sampleRate, smoothingFactor, adcScaling) 
// SmoothAnalogIn tc2(p16,0.01,500,3300);            // (PinName, sampleRate, smoothingFactor, adcScaling) 
// tc1.read()                                        // return tc1 smoothed adc value


#include "mbed.h"                           // tested with revision 23

class SmoothAnalogIn    {                   // Class

    public:
    
        SmoothAnalogIn(PinName pin, float sampleRate, int smoothingFactor, int adcScaling);
        
        double read (void);                 // public- returns smoothed adc value
        
        
    private:
    
        // private objects
        
        AnalogIn _adc;                      // AnalogIn
        Ticker _ticker;                     // Ticker within class
    
        // private functions
        
        void smoothValue(double);           // function to smooth adc value
        void sampleAdc(void);               // gets current adc value and then calls smoothing function 'void smoothValue(double);'  
       
       
       // private variables
       
       double smoothed;                     // smoothed adc value
       int _smoothingFactor;                // instance value - smoothing factor
       int _adcScaling;                     // instance value -adc scaling factor
             
                        };