/* This program is based on the Ser25LCxxx_test program by Hendrik Lipka
* It was adapted to flash25spi library on 19.2.2011 by Klaus Steinhammer
* the BSD license also applies to this code - have fun. 
*/

/*
* Ser25LCxxx_test program
* Copyright (c) 2010 Hendrik Lipka
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/



#include "mbed.h"
#include "flash25spi.h"

void dumpLine(char* s, int len)
{
    for (int i=0;i<len;i++)
    {
        printf("%X ",s[i]);
    }
    printf("\n");
}

void dump(char *s, int len)
{
    int i=0;
    while (i<len)
    {
        if (i+16<len)
            dumpLine(s+i,16);
        else
            dumpLine(s+i,len-i);
        i+=16;
    }
}

int main() {
    printf("******** [%s] *********\n",__TIME__);
    // setup hardware
    SPI spi(p5,p6,p7);
    spi.format(8,3);
    spi.frequency(1000000);
    // /CS is connected to p8, chip,in question is a en25q32 (4Mx8, 256-byte page, 4k sectorsize, 64k blocksize)
    flash25spi flash(&spi, p8);
    
    int len=512;
    
    printf("dump initial memory content (2 pages)\n");
    char* r=flash.read(0xff00,len);
    dump(r,len);
    printf("\n");
    
    // write some stuff to the first and second page
    char buf[64];
    sprintf(buf,"******** [%s] *********\n",__TIME__);
    
    bool b=flash.write(0xfff0,strlen(buf),buf);

    printf("read written data back (2 pages)\n");
    r=flash.read(0xff00,len);
    dump(r,len);
    printf("\n");
    
    printf("clear first page, read 2 pages back\n");
    flash.clearSector(0xff00);
    r=flash.read(0xff00,len);
    dump(r,len);
    printf("\n");
    
    printf("clear everything, read 2 pages back\n");
    flash.clearMem();
    r=flash.read(0xff00,len);
    dump(r,len);
    printf("\n");
    
}
