/*This is the RECEIVER code of Laser Communication Protocol v1.0 developed by
Ivan Mihov, Stoil Ivanov and Zdravko Dimitrov. The protocol was developed during
the HEPTA-Sat training held in the Faculty of Physics at Sofia University
"St. Kliment Ohridski", Bulgaria. The training was conducted from 24th to
28th of October 2017 with instructors Dr. Masahiko Yamazaki, Mr. Takafumi
Umezawa and Mr. Riku Sato.

For contacting the developers, please use e-mails:
ipmihov@gmail.com - Ivan Mihov
stoil.n.ivanov@gmail.com - Stoil Ivanov
z.dimitrov91@gmail.com - Zdravko Dimitrov
We will be glad to help!*/

#include "mbed.h"
#include "SDFileSystem.h"
#include "HeptaXbee.h"
#include "HeptaCamera_GPS.h"
#include "Hepta9axis.h"
#include "HeptaTemp.h"
#include "HeptaBattery.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


Serial pc(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd");
HeptaXbee xbee(p9,p10);
HeptaCamera_GPS cam_gps(p13, p14,p25,p24);
Hepta9axis n_axis(p28,p27,0xD0,0x18);
HeptaTemp temp(p17);
AnalogIn light(p18);
PwmOut led(p21);
HeptaBattery battery(p16,p26);
DigitalOut myled(LED1);


//Definition of MORSE and ASCII structure variables
typedef struct {
    char* morse;
    char* ascii;
} morse_table_t;

int main()
{

//Morse code dictionary
    morse_table_t table[] = { {".-", "A"},
        {"-...", "B"},
        {"-.-.", "C"},
        {"-.." , "D"},
        {"." , "E"},
        {"..-." , "F"},
        {"--." , "G"},
        {"...." , "H"},
        {".." , "I"},
        {".---" , "J"},
        {"-.-" , "K"},
        {".-.." , "L"},
        {"--" , "M"},
        {"-." , "N"},
        {"---" , "O"},
        {".--." , "P"},
        {"--.-" , "Q"},
        {".-." , "R"},
        {"..." , "S"},
        {"-" , "T"},
        {"..-" , "U"},
        {"...-" , "V"},
        {".--" , "W"},
        {"-..-" , "X"},
        {"-.--" , "Y"},
        {"--.." "Z"},
        {"-----" ,"0"},
        {".----" ,"1"},
        {"..---" , "2"},
        {"...--" , "3"},
        {"....-" , "4"},
        {"....." , "5"},
        {"-...." ,"6"},
        {"--..." , "7"},
        {"---.." , "8"},
        {"----." , "9"},
        {"/" , " "}
    };
    pc.baud(9600);

    char symbol,space;
    char mes[100];
    float count=0.0,count_on=0.0,count_off=0.0 ;
    float current,vol,sig,lux;
    
    led = 1;

//Creating directory for storing the laser message on the SD card
    mkdir("/sd/LaserComms", 0777);
    
//Creating and opening a file 'for writing' the morse message
    FILE *fp = fopen("/sd/LaserComms/message.txt", "w");
    if(fp == NULL) {
        error("Could not open file for writing\r\n");
    }

//Sequence for 'start bit'
    while (1) {
        do {
            vol = light.read();
            sig = 3.3*1.947*vol;
            current = sig * 100;
            lux = (current)*2;
            
            if (lux > 300) {
                count = count + 0.1;
            } else {
                count = 0.0;
            }

            xbee.printf("lux= %f , current= %f ,vol= %f , count= %f \r\n",lux,current,vol,count);
            wait (0.1);
        } while (count <= 3.0); //Condition for 'start bit'

//'Start bit' received
xbee.printf("LASER COMMUNICATION ESTABLISHED! RECEIVING MODE ON!\r\n");

//Laser signal reading starts
        lux=0;
        while(1) {
            count_on = 0.0;
            count_off = 0.0;

//----------- While loop for 'spaces' in the message
            while(lux < 300) {
                xbee.printf("lux= %f, count_off= %f \r\n",lux,count_off);
                count_off = count_off + 0.05;
                wait(0.05);
                vol = light.read();
                sig = 3.3*1.947*vol;
                current = sig * 100;
                lux = (current)*2;
            }
 
 //Condition for defining the type of the 'space signal'
 //Currently developed for single words only
            if (count_off >= 0.5) {
                space = 'x';
                fprintf(fp,"%c",space);
            }

//Check for 'stop bit'
            if (count_off > 3.0) {
                break;
            }

//----------- While loop for 'symbols' in the message
            while(lux >= 300) {
                xbee.printf("lux= %f, count_on= %f \r\n",lux,count_on);
                count_on = count_on + 0.05;
                wait(0.05);
                vol = light.read();
                sig = 3.3*1.947*vol;
                current = sig * 100;
                lux = (current)*2;
            }
            
//Condition for defining the type of the 'symbol signal'
            if (count_on >= 0.5) {
                symbol = '-';
                fprintf(fp,"%c",symbol);
            } else {
                symbol = '.';
                fprintf(fp,"%c",symbol);
            }

//Check for 'stop bit'
            if (count_off > 3.0) {
                break;
            }
        }

//At this point the 'stop bit' has been received    
    fclose(fp);

//The message was written in a file on the SD card

//Now we open the same file to read the message and store it in a string 
    fp = fopen("/sd/LaserComms/message.txt","r");
    fgets(mes,100,fp);
    fclose(fp);

//Check if the message is not empty
        if (mes != "\0") {
            xbee.printf("Message accepted successfully! \r\n");
            xbee.printf("Morse: %s\r\n Translating... \r\n",mes);
        }

//Definitiom of characters and strings for the Morse Code Translator
        char* segment;
        char final_mes[100];
        int i;

//Here we divide the message in 'segments' using the symbol for space 'x'
        segment = strtok(mes, "x");
        
        xbee.printf("Translated: ");
        
//We create a file to store the final translated message
        FILE *fh = fopen("/sd/LaserComms/final_message.txt", "w");
        if(fh == NULL) {
            error("Could not open file for writing\r\n");
        }

//The Morse-to- text translation sequence starts
        while(segment) {
            for(i=0; i<37; ++i) {
//Here we compare the message segment with the defined Morse code dictionary
                if (!strcmp(segment, table[i].morse)) {
//The translated message is sent to the Ground Station
                    xbee.printf("%s",(table[i].ascii));
//The translated message is stored in a file on the SD card                    
                    fprintf(fh,"%s",(table[i].ascii));
                    break;
                }
            }
            segment = strtok(NULL, "x");
        }
        fclose(fh);

//We open the file, which contains the translated message
        fh = fopen("/sd/LaserComms/final_message.txt","r");
//The file is read and the translated message is stored in a string
        fgets(final_mes,100,fh);
        fclose(fh);

//From here on we define few commands, depending on the message content

//------- TELEMETRY COMMAND
        if (!strcmp(final_mes, "TELEMETRY")) {
            xbee.printf("Telemetry requested!");
            cam_gps.gps_setting();
            float gx,gy,gz,ax,ay,az,mx,my,mz,bt,temper;
            char ns='A',ew='B',aunit='m';
            float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
            int quality=0,stnum=0,gps_check=0;
            for(int i = 0; i < 10; i++) {
                n_axis.sen_gyro(&gx,&gy,&gz);
                n_axis.sen_acc(&ax,&ay,&az);
                n_axis.sen_mag(&mx,&my,&mz);
                battery.vol(&bt);
                temp.temp_sense(&temper);
                cam_gps.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
                xbee.printf("gx = %f gy = %f gz = %f\r\n",gx,gy,gz);
                xbee.printf("ax = %f ay = %f az = %f\r\n",ax,ay,az);
                xbee.printf("mx = %f my = %f mz = %f\r\n",mx,my,mz);
                xbee.printf("Temperature = %f\r\n",temper);
                xbee.printf("Battery voltage: = %f[V]\r\n",bt);
                xbee.printf("%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
                led = (i%2);
                wait(1.0);
            }
            xbee.initialize();
        }

//------- PHOTO COMMAND
        if (!strcmp(final_mes, "PHOTO")) {
//---------LED blinks several times
            for(int i = 0; i < 7; i++) {
            led = (i%2); 
            wait(0.2);
            }

            xbee.printf("Photo requested! \r\n Camera Snapshot Mode\r\n\n Please, smile! :) \r\n");
            cam_gps.Sync();
            cam_gps.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution640x480);
            cam_gps.test_jpeg_snapshot_picture(1);
            led = 1;
        }

//------- SOS COMMAND
        if (!strcmp(final_mes, "SOS")) {

// LED blinks SOS message
xbee.printf("LEDs blinks SOS message! \r\n");

        led=0;
        wait(0.2);

// 'S' letter: . . .      
        led = 1;
        wait(0.2);
        
        led = 0;
        wait(0.2);
        
        led = 1;
        wait(0.2);
        
        led = 0;
        wait(0.2);
        
        led = 1;
        wait(0.2);
        
//Space between letters
        led = 0;
        wait(0.7);

// 'O' letter: - - -
        led = 1;
        wait(0.7);
        
        led = 0;
        wait(0.2);
        
        led = 1;
        wait(0.7);
        
        led = 0;
        wait(0.2);

        led = 1;
        wait(0.7);
        
//Space between letters
        led = 0;
        wait(0.7);
        
// 'S' letter: . . .      
        led = 1;
        wait(0.2);
        
        led = 0;
        wait(0.2);
        
        led = 1;
        wait(0.2);
        
        led = 0;
        wait(0.2);
        
        led = 1;
        wait(0.2);
        
        led = 0;
        xbee.printf("SOS message sent back the Earth with the LED! \r\n");
        }
    }
}