#ifndef _RST_H
#define _RST_H

#include "mbed.h"
#include "math.h"

#define UPPER_LIMIT 1
#define LOWER_LIMIT 0
#define MAX_GRADE  10

typedef struct
{
    float setpoint;
    uint8_t gradR;
    uint8_t gradS;
    uint8_t gradT;
} RST_aditionalData;

class RST{
    
    public:
        RST(float* R, float* S, float* T, RST_aditionalData SP);
        float* getR(){return m_R;}
        float* getS(){return m_S;}
        float* getT(){return m_T;}
        void setR(float *new_R){m_R = new_R;}
        void setS(float *new_S){m_S = new_S;}
        void setT(float *new_T){m_T = new_T;}
        
        float ComputeCommand(float inputADC);
        
    private:
        float* m_R;
        float* m_S;
        float* m_T;
        RST_aditionalData m_SP;
};

#endif