#ifndef _PID_H_
#define _PID_H_

#include "mbed.h"
#include "math.h"

#define Te 100
#define SUPERIOR_MARGIN 1
#define INFERIOR_MARGIN 0 

typedef struct
{
    float last_error;
    float integral;
}PID_static;

class PIDClass
{
     public:   
        PIDClass(float _Kr, float _Ki, float _Kd, float _SetPoint);

        float ComputeCommand(float inputADC);
        float getKr(){return Kr;}
        float getKi(){return Ki;}
        float getKd(){return Kd;}
        void setKr(float new_Kr){Kr = new_Kr;}
        void setKi(float new_Ki){Ki = new_Ki;}
        void setKd(float new_Kd){Kd = new_Kd;}
        
     private:
        float Kr;
        float Ki;
        float Kd;   
        float SetPoint;
};

#endif