/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
and associated documentation files (the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

/*
 *    The application works with the BLEController iOS/Android App.
 *    Type something from the Terminal to send
 *    to the BLEController App or vice verse.
 *    Characteristics received from App will print on Terminal.
 */
 
#include "mbed.h"
#include "BTDevice.hpp"
#include "ControllerFactory.hpp"

BLE  ble;
Ticker periodicCommand;

Serial pc(USBTX, USBRX);

BTDevice Nano(ble);
ControllerFactory Control_Law();
//Controller c;
char *old_receive = NULL;
float R[3] = {0.1,0.4,0.6};
float S[3] = {0.2,0.1,0.5};
float T[4] = {0.1,0.7,0.5};
ControllerParams Parameters;


// The Nordic UART Service

/*decode(uint8_t *receive, Controller *c);

void state_machine(uint8_t *receive)
{
            switch((char *)receive)
            {
                case 'P': 
                {
                    Control_Law.createController(&c, P);
                    Parameters.kp = 0.1;
                    Control_Law.createControllerParams(&c, P, &Parameters, 0);
                    c.updateRef(0.5);
                } 
                case 'PI':
                {
                    Control_Law.createController(&c, PI);    
                    Parameters.kp = 0.1;
                    Parameters.ti = 0.3;
                    Control_Law.createControllerParams(&c, PI, &Parameters, 0);
                    c.updateRef(0.7);
                }
                case 'PID':
                {
                    Control_Law.createController(&c, PID);  
                    Parameters.kp = 0.1;
                    Parameters.ti = 0.3; 
                    Parameters.td = 0.15;
                    Control_Law.createControllerParams(&c, PID, &Parameters, 0);
                    c.updateRef(0.9);
                }
                case 'RST':
                {
                    Control_Law.createController(&c, RST);  
                    Parameters.ordR = sizeof(R)/sizeof(*R);
                    Parameters.ordS = sizeof(S)/sizeof(*S);
                    Parameters.ordT = sizeof(T)/sizeof(*T);
                    Parameters.R = R;
                    Parameters.S = S;
                    Parameters.T = T;
                    Control_Law.createControllerParams(&c, RST, &Parameters, Parameters.ordT);
                    c.updateRef(1);
                }
                case 'delete':
                {
                    delete c;  
                }
            }    
        decode_message(&receive, &c);
}

decode_message(uint8_t *receive, Controller c)
{
      switch((char *)receive)
      {
            case 'Command':
            {
                  Nano.sendMsg((uint8_t *),c.calculateCmd, 16);  
            }
      }
}*/


void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    pc.printf("Disconnected \r\n");
    pc.printf("Restart advertising \r\n");
    ble.startAdvertising();
}

void WrittenHandler(const GattWriteCallbackParams *Handler)
{   
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead, index;
    
    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle()) 
    {
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, buf, TXRX_BUF_LEN);       
        //state_machine(&buf);
    }
}

void uartCB(void)
{   
    while(pc.readable())    
    {
        rx_buf[rx_len++] = pc.getc();    
        if(rx_len>=20 || rx_buf[rx_len-1]=='\0' || rx_buf[rx_len-1]=='\n')
        {
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len); 
            rx_len = 0;
            break;
        }
    }
}

int main(void)
{
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(WrittenHandler);  
    
    pc.baud(9600);
    pc.printf("SimpleChat Init \r\n");
    
    pc.attach( uartCB , pc.RxIrq);
   // setup advertising 
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)"Gigel", sizeof("Biscuit") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    // 100ms; in multiples of 0.625ms. 
    ble.setAdvertisingInterval(160);

    ble.addService(uartService);
    
    ble.startAdvertising(); 
    pc.printf("Advertising Start \r\n");
    
    while(1)
    {
        ble.waitForEvent(); 
    }
}
















