#ifndef PIDCONTROLLER_H
#define PIDCONTROLLER_H

#include "Controller.hpp"
#include "ControllerParams.hpp"

#define TE      0.1
#define dif(a,b)    (a-b)

class PIDController : public Controller {

    private:
        float kp;
        float ti;
        float td;
    
    public:
    
        virtual void updateParams(ControllerParams&);   
        virtual float calculateCmd(void) const;
        virtual ~PIDController();

        void setKp(float);
        float getKp() const;
        
        void setTi(float);
        float getTi() const;
    
        void setTd(float);
        float getTd() const;        
};

#endif
