
#include "ControllerFactory.hpp"


void ControllerFactory::createController (Controller *c, SysObjTypes &ctrlType) {
    
    switch (ctrlType) {
        case P:         //fall-through
        case PI:
        case PID: {
            c = new PIDController();
            break; 
        }
        case RST: {
            //c = new RST::RST();
            break;
        }
        default: c = 0;
    }
}

void ControllerFactory::createControllerParams (ControllerParams &cp, SysObjTypes &ctrlType, float *paramsList, int paramsListLen) {
    /*
        paramsList form: {
            P: [kp] 
            PI: [kp, ti]
            PID: [kp, ti, td]
            RST: [nR,r0,r1,...,r_nR,nS,s0,s1,...,s_nS,nT,t0,t1,...,t_nT]
        }
        cond: paramsListLen = nR + nS + nT + 6
    */
    switch (ctrlType) {
        case P: {
            cp.kp = *paramsList;
            cp.ti = 0;
            cp.td = 0;
            break;
        }
        case PI: {
            cp.kp = *paramsList;
            cp.ti = paramsList[1];
            cp.td = 0;
            break;
        }
        case PID: {
            cp.kp = *paramsList;
            cp.ti = paramsList[1];
            cp.td = paramsList[2];
            break;
        }
        case RST: {
            int i;
            cp.ordR = *paramsList;
            cp.R = new float[cp.ordR+1];
            for (i=1; i<cp.ordR+2;i++) {
                cp.R[i] = paramsList[i];
            }
            cp.ordS = paramsList[i];
            cp.S = new float[cp.ordS+1];
            for (i=cp.ordR+2; i<cp.ordR+cp.ordS+3; i++) {
                cp.S[i] = paramsList[i];        
            }
            cp.ordT = paramsList[i];
            cp.T = new float[cp.ordT+1];
            for(i=cp.ordR+cp.ordS+3; i<paramsListLen; i++) {
                cp.T[i] = paramsList[i];
            }
            break;
        }
    }       
}

