#ifndef _BTdevice_
#define _BTdevice_

#include "ble/BLE.h"
#include <Gap.h>
#include "ControllerParams.hpp"
#include "Controller.hpp"
#include "CmdEnums.hpp"

#define TXRX_BUF_LEN    20

#define BLE_UUID_TXRX_SERVICE            0x0000 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_TX_CHARACTERISTIC       0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUIDS_RX_CHARACTERISTIC      0x0003 /**< The UUID of the RX Characteristic. */

// The Nordic UART Service
static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};


uint8_t txPayload[TXRX_BUF_LEN] = {0};
uint8_t rxPayload[TXRX_BUF_LEN] = {0};


static uint8_t rx_buf[TXRX_BUF_LEN];
static uint8_t rx_len=0;


GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
                                      
GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
                                      
GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic};

GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));



class BTDevice {
    
    public:
        BTDevice(BLE _ble);
        BTDevice();
        void sendMsg(char *buf, uint16_t length);
        int readMsg(uint8_t buf[TXRX_BUF_LEN], uint16_t expectedLen);

        void attachController(Controller *c);
        void setCtrlRef(float ref);
        void setCtrlParams(ControllerParams &cp);

        void interpretCmd(uint8_t cmd[TXRX_BUF_LEN]);
        ~BTDevice();        

    //friend void getTokens(uint8_t cmd[TXRX_BUF_LEN], BTDevive&, SysObj&, SysObjTypes&, Actions&, uint8_t actionParams[TXRX_BUF_LEN]);
        
    private:
        BLE ble;
        Controller *ctrl;
        float out;
};
#endif