#include "BTDevice.hpp"

BTDevice::BTDevice() {
    this->ctrl = NULL;
}

BTDevice::BTDevice(BLE _ble):ble(_ble){}

BTDevice::~BTDevice() { 
    delete this->ctrl; 
} 

void BTDevice::sendMsg(char *buf, uint16_t length) {
    ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), (const uint8_t*)buf, length);
}

int BTDevice::readMsg(uint8_t buf[TXRX_BUF_LEN], uint16_t expectedLen) {
    uint16_t bytesRead;
    ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
    
    return (bytesRead == expectedLen)? bytesRead : -1;
}

void BTDevice::attachController(Controller *c) { 
    this->ctrl = c; 
}

void BTDevice::setCtrlRef(float ref) {
    this->ctrl->updateRef(ref);
}

void BTDevice::setCtrlParams(ControllerParams &cp) {
    this->ctrl->updateParams(cp);
}

