#include "mbed.h"
#include "kor_char_code.h"
#include <stdint.h>

#define        COV_RATIO                       0.2            //ug/mmm / mv
#define        NO_DUST_VOLTAGE                 400            //mv
#define        SYS_VOLTAGE                     5000       

Serial pc(USBTX,USBRX); // tx, rx
Serial TFT(PC_02,PC_03); // tx, rx
Serial lora(PA_13,PA_14); // tx, rx
Timer timer;
AnalogIn dustVal(A0);
DigitalOut myled(D6);
int flag_first = 0;

int calibration(int m)
{
  static int _buff[10], sum;
  const int _buff_max = 10;
  int i;
  
  if(flag_first == 0)
  {
    flag_first = 1;

    for(i = 0, sum = 0; i < _buff_max; i++)
    {
      _buff[i] = m;
      sum += _buff[i];
    }
    return m;
  }
  else
  {
    sum -= _buff[0];
    for(i = 0; i < (_buff_max - 1); i++)
    {
      _buff[i] = _buff[i + 1];
    }
    _buff[9] = m;
    sum += _buff[9];
    
    i = sum / 10.0;
    return i;
  }
}
	

int main()
{
    char buffer[200];
    TFT.baud(115200);
    lora.baud(38400);
    unsigned int curr_Time1;
    unsigned int curr_Time2;
    float analogVal =0;
    int analogVal_u16 =0;
    float digitalVal =0;
    float dustDensity =0;
    int samplingTime = 280;
    int deltaTime = 40;
    int sleepTime = 9680;
    int x=1;
    int y=1;
    int w = 500;
    int h = 220;
    int red = 255;
    int green = 255;
    int blue = 255;
    int fill=1;

    timer.start();
    curr_Time1 = timer.read();
    TFT.printf("$l,0,%d,%d,%d#",red,green,blue); // 사각형 색(흰색) 지정
    lora.printf("AT+RST\r\n");  

    while(1)
    {
        /*
        if(lora.readable()){
            lora.gets(buffer,40);

            if( strstr(buffer,"JOINED\r\n") == NULL ){
                TFT.printf("$f,4,1,#"); // 글자 크기 조절
                TFT.printf("$f,0,Not joined ,1,120,#\r\n");
                continue;
            }
            
            if( strstr(buffer,"JOINED\r\n") != NULL ){
                TFT.printf("$f,0,joined !!! ,1,140,#");
                continue;
            }
            
        }*/
        TFT.printf("$f,4,2,#"); // 글자 크기 조절
        curr_Time2 = timer.read();

		
        if( curr_Time2-curr_Time1 == 1) {
        	
        myled = 0;
        wait_us(samplingTime);

        analogVal = dustVal.read();
        analogVal_u16 = dustVal.read_u16();
        wait_us(deltaTime);
        myled = 1;
        wait_us(sleepTime);
        
        analogVal_u16 = calibration(analogVal_u16); // 보정

        //digitalVal = analogVal_u16 *(5.0/4096);
        digitalVal =  (SYS_VOLTAGE / 4096.0) * analogVal_u16; //adc변 (mv)
        // dustDensity = (0.17*digitalVal) -0.1;
        
        if(digitalVal >= NO_DUST_VOLTAGE)
        {
          	digitalVal -= NO_DUST_VOLTAGE;
          	dustDensity = digitalVal * COV_RATIO; // Voltage(mv)값을  dust density로 변(ug/m3)
          	dustDensity -= 50;
        }
        else
        {
            dustDensity = 0;
        }
        

		TFT.printf("$l,2,%d,%d,%d,%d,%d#",x,y,w,h,fill==0?0:1); //흰 사각형 출력(지우기)
		TFT.printf("$f,0,Fine Dust(PM 2.5),1,1,#\r\n");    
		TFT.printf("$f,0,Value : %f (ug/m3),1,30,#\r\n",dustDensity);        	
        TFT.printf("$f,0,current Time : %f (s),1,60,#\r\n",timer.read());
        
        if( (dustDensity>=0) && (dustDensity<=15) )
        {
        	TFT.printf("$f,0,STATUS :,1,90,#\r\n"); 
        	TFT.printf("$f,1,0,174,240#\r\n"); 
        	TFT.printf("$f,0,GOOD :> ,140,90,#\r\n");   
        	TFT.printf("$f,1,0,0,0#\r\n"); 
        	 
        }
        
        else if( (dustDensity>=16) && (dustDensity<=50) )
        {
        	TFT.printf("$f,0,STATUS :,1,90,#\r\n"); 
        	TFT.printf("$f,1,120,254,98#\r\n"); 
        	TFT.printf("$f,0,NORMAL :) ,140,90,#\r\n");  
        	TFT.printf("$f,1,0,0,0#\r\n");   
        }
        
        else if( (dustDensity>=51) && (dustDensity<=100) )
        {
        	TFT.printf("$f,0,STATUS :,1,90,#\r\n"); 
        	TFT.printf("$f,1,255,255,75#\r\n"); 
        	TFT.printf("$f,0,BAD :( ,140,90,#\r\n");   
        	TFT.printf("$f,1,0,0,0#\r\n");  
        }
        
        else if(dustDensity>=101)
        {
        	TFT.printf("$f,0,STATUS :,1,90,#\r\n"); 
        	TFT.printf("$f,1,255,51,51#\r\n"); 
        	TFT.printf("$f,0,DANGER :<,140,90,#\r\n");  
        	TFT.printf("$f,1,0,0,0#\r\n");   
        }
        else
        {
        	TFT.printf("$f,0,STATUS :,1,90,#\r\n"); 
        	TFT.printf("$f,1,0,0,0#\r\n"); 
        	TFT.printf("$f,0,WAIT !,140,90,#\r\n");
        	TFT.printf("$f,1,0,0,0#\r\n");    
        }
        	
            
        //lora.printf("AT+SEND 01015445//\r\n");  

        curr_Time1 = curr_Time2;
        }
    }
}


