#pragma once
bool lcd_connect(int portnum);
void lcd_disconnect();
bool lcd_is_open();
//void set_receive_window(HWND h, UINT msg);

bool send_command(char* str);

bool lcd_connect_check();
bool lcd_set_double_buffer_mode();
bool lcd_set_single_buffer_mode();
bool lcd_brightness(int val);
bool lcd_flip();
bool lcd_usb_mass_storage();
bool lcd_reset();

bool lcd_set_color(unsigned char r, unsigned char g, unsigned char b);
bool lcd_draw_line(int x, int y, int endx, int endy);
bool lcd_draw_rect(int x, int y, int w, int h, bool bfill);
bool lcd_draw_rect_gradient(int x, int y, int w, int h, unsigned char sr, unsigned char sg, unsigned char sb, unsigned char er, unsigned char eg, unsigned char eb);
bool lcd_draw_rect_rounded(int x, int y, int w, int h, int rad, bool bfill);
bool lcd_draw_thickline(int x, int y, int endx, int endy, int thick);
bool lcd_draw_circle(int x, int y, int r, bool bfill);
bool lcd_draw_ellipse(int x, int y, int rx, int ry, bool bfill);

bool lcd_image_load(int index, char* fname);
bool lcd_image_draw(int index, int x, int y);
bool lcd_image_draw_rect(int index, int x, int y, int sx, int sy, int w, int h);
bool lcd_image_draw_scale(int index, int x, int y, int w, int h);
bool lcd_image_draw_scale_rect(int index, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh);
bool lcd_image_release(int index);

bool lcd_textcolor(unsigned char r, unsigned char g, unsigned char b);
bool lcd_textout(char* str, int x, int y);

bool lcd_set_touchmode(bool bAsync);
bool lcd_get_touch(unsigned short *x, unsigned short *y);

bool lcd_run_script(char* fname);

int lcd_get_serial_data(unsigned char* buf);


