/*
 * ----------------------------------------------------------------------------
 *          Header file for Korean character code conversion functions
 *                              written by Jungho Moon
 * ----------------------------------------------------------------------------
 */
 #include <stdint.h>

#ifndef KOR_CHAR_CODE_H
#define KOR_CHAR_CODE_H

#define KOR_CHAR_CODE

#ifdef  KOR_CODE_GLOBALS
#define KOR_CODE_EXT
#else
#define KOR_CODE extern
#endif

// global variables
extern unsigned char table_initial[21];
extern unsigned char table_vowel[30];
extern unsigned char table_final[30];
extern unsigned char bul_initial[2][22];
extern unsigned char bul_final[22];

// function prototypes
uint16_t korean_ks2kssm_converter(uint16_t);
uint16_t korean_kssm2ks_converter(uint16_t);
uint16_t korean_unicode2kssm_converter(uint16_t);
uint16_t korean_unicode2ks_converter(uint16_t);
#endif

