/*
 * ----------------------------------------------------------------------------
 *                      English and Korean fonts
 *                              written by Jungho Moon
 *                              fonts data collected from the Internet
 * ----------------------------------------------------------------------------
 */

#ifndef GLCD_FONTS_H
#define GLCD_FONTS_H

#define KOR_FONTS

#ifdef KOR_FONTS
    #define KOR_FONT_MGOTH
    #define KOR_FONT_IYAGI
    #define KOR_FONT_PILGI
    #define KOR_FONT_HMGOTH
#endif

// ASCii 7x8 English font
prog_uint8_t eng_font_7x8[] = {
     0,   0,   0,   0,   0,   0,   0,       //0x20 space
     0,   6,  95,  95,   6,   0,   0,       //0x21 !
     0,   7,   7,   0,   7,   7,   0,       //0x22 "
    20, 127, 127,  20, 127, 127,  20,       //0x23 #
    36,  46, 107, 107,  58,  18,   0,       //0x24 $
    70, 102,  48,  24,  12, 102,  98,       //0x25 %
    48, 122,  79,  93,  55, 122,  72,       //0x26 &
     4,   7,   3,   0,   0,   0,   0,       //0x27 '
     0,  28,  62,  99,  65,   0,   0,       //0x28 (
     0,  65,  99,  62,  28,   0,   0,       //0x29 )
     8,  42,  62,  28,  28,  62,  42,       //0x2a *
     8,   8,  62,  62,   8,   8,   0,       //0x2b +
     0, 128, 224,  96,   0,   0,   0,       //0x2c ,
     8,   8,   8,   8,   8,   8,   0,       //0x2d -
     0,   0,  96,  96,   0,   0,   0,       //0x2e .
    96,  48,  24,  12,   6,   3,   1,       //0x2f /
    62, 127, 113,  89,  77, 127,  62,       //0x30 0
    64,  66, 127, 127,  64,  64,   0,       //0x31 1
    98, 115,  89,  73, 111, 102,   0,       //0x32 2
    34,  99,  73,  73, 127,  54,   0,       //0x33 3
    24,  28,  22,  83, 127, 127,  80,       //0x34 4
    39, 103,  69,  69, 125,  57,   0,       //0x35 5
    60, 126,  75,  73, 121,  48,   0,       //0x36 6
     3,   3, 113, 121,  15,   7,   0,       //0x37 7
    54, 127,  73,  73, 127,  54,   0,       //0x38 8
     6,  79,  73, 105,  63,  30,   0,       //0x39 9
     0,   0, 102, 102,   0,   0,   0,       //0x3a :
     0, 128, 230, 102,   0,   0,   0,       //0x3b ;
     8,  28,  54,  99,  65,   0,   0,       //0x3c <
    36,  36,  36,  36,  36,  36,   0,       //0x3d =
     0,  65,  99,  54,  28,   8,   0,       //0x3e >
     2,   3,  81,  89,  15,   6,   0,       //0x3f ?
    62, 127,  65,  93,  93,  31,  30,       //0x40 @
    124, 126,  19,  19, 126, 124,   0,      //0x41 A
    65, 127, 127,  73,  73, 127,  54,       //0x42 B
    28,  62,  99,  65,  65,  99,  34,       //0x43 C
    65, 127, 127,  65,  99,  62,  28,       //0x44 D
    65, 127, 127,  73,  93,  65,  99,       //0x45 E
    65, 127, 127,  73,  29,   1,   3,       //0x46 F
    28,  62,  99,  65,  81, 115, 114,       //0x47 G
    127, 127,   8,   8, 127, 127,   0,      //0x48 H
     0,  65, 127, 127,  65,   0,   0,       //0x49 I
    48, 112,  64,  65, 127,  63,   1,       //0x4a J
    65, 127, 127,   8,  28, 119,  99,       //0x4b K
    65, 127, 127,  65,  64,  96, 112,       //0x4c L
    127, 127,  14,  28,  14, 127, 127,      //0x4d M
    127, 127,   6,  12,  24, 127, 127,      //0x4e N
    28,  62,  99,  65,  99,  62,  28,       //0x4f O
    65, 127, 127,  73,   9,  15,   6,       //0x50 P
    30,  63,  33, 113, 127,  94,   0,       //0x51 Q
    65, 127, 127,   9,  25, 127, 102,       //0x52 R
    38, 111,  77,  89, 115,  50,   0,       //0x53 S
     3,  65, 127, 127,  65,   3,   0,       //0x54 T
    127, 127,  64,  64, 127, 127,   0,      //0x55 U
    31,  63,  96,  96,  63,  31,   0,       //0x56 V
    127, 127,  48,  24,  48, 127, 127,      //0x57 W
    67, 103,  60,  24,  60, 103,  67,       //0x58 X
     7,  79, 120, 120,  79,   7,   0,       //0x59 Y
    71,  99, 113,  89,  77, 103, 115,       //0x5a Z
     0, 127, 127,  65,  65,   0,   0,       //0x5b [
     1,   3,   6,  12,  24,  48,  96,       //0x5c 
     0,  65,  65, 127, 127,   0,   0,       //0x5d ]
     8,  12,   6,   3,   6,  12,   8,       //0x5e ^
    128, 128, 128, 128, 128, 128, 128,      //0x5f _
     0,   0,   3,   7,   4,   0,   0,       //0x60 `
    32, 116,  84,  84,  60, 120,  64,       //0x61 a
    65, 127,  63,  72,  72, 120,  48,       //0x62 b
    56, 124,  68,  68, 108,  40,   0,       //0x63 c
    48, 120,  72,  73,  63, 127,  64,       //0x64 d
    56, 124,  84,  84,  92,  24,   0,       //0x65 e
    72, 126, 127,  73,   3,   2,   0,       //0x66 f
    56, 188, 164, 164, 252, 120,   0,       //0x67 g
    65, 127, 127,   8,   4, 124, 120,       //0x68 h
     0,  68, 125, 125,  64,   0,   0,       //0x69 i
    96, 224, 128, 128, 253, 125,   0,       //0x6a j
    65, 127, 127,  16,  56, 108,  68,       //0x6b k
     0,  65, 127, 127,  64,   0,   0,       //0x6c l
    120, 124,  28,  56,  28, 124, 120,      //0x6d m
    124, 124,   4,   4, 124, 120,   0,      //0x6e n
    56, 124,  68,  68, 124,  56,   0,       //0x6f o
    0, 252, 252, 164,  36,  60,  24,        //0x70 p
    24,  60,  36, 164, 248, 252, 132,       //0x71 q
    68, 124, 120,  76,   4,  28,  24,       //0x72 r
    72,  92,  84,  84, 116,  36,   0,       //0x73 s
     0,   4,  62, 127,  68,  36,   0,       //0x74 t
    60, 124,  64,  64,  60, 124,  64,       //0x75 u
    28,  60,  96,  96,  60,  28,   0,       //0x76 v
    60, 124, 112,  56, 112, 124,  60,       //0x77 w
    68, 108,  56,  16,  56, 108,  68,       //0x78 x
    60, 188, 160, 160, 252, 124,   0,       //0x79 y
    76, 100, 116,  92,  76, 100,   0,       //0x7a z
     8,   8,  62, 119,  65,  65,   0,       //0x7b {
     0,   0,   0, 119, 119,   0,   0,       //0x7c |
    65,  65, 119,  62,   8,   8,   0,       //0x7d }
     2,   3,   1,   3,   2,   3,   1,       //0x7e ~
    255, 129,  129,  129,  129, 129, 255,   //''
    14, 159, 145, 177, 251,  74,   0        //'?
};
             
// ASCii 8x16 English font
prog_uint8_t eng_font_8x16[] = {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    // space
    0x00,0x00,0x00,0x00,0x00,0x38,0x0D,0xFC,0x0D,0xFC,0x00,0x38,0x00,0x00,0x00,0x00,    // !
    0x00,0x00,0x00,0x0E,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x0E,0x00,0x00,    // "
    0x02,0x20,0x0F,0xF8,0x0F,0xF8,0x02,0x20,0x0F,0xF8,0x0F,0xF8,0x02,0x20,0x00,0x00,    // #
    0x06,0x38,0x0C,0x7C,0x08,0x44,0x38,0x47,0x38,0x47,0x0F,0xCC,0x07,0x98,0x00,0x00,    // $
    0x0C,0x30,0x06,0x30,0x03,0x00,0x01,0x80,0x00,0xC0,0x0C,0x60,0x0C,0x30,0x00,0x00,    // %
    0x07,0x80,0x0F,0xD8,0x08,0x7C,0x08,0xE4,0x07,0xBC,0x0F,0xD8,0x08,0x40,0x00,0x00,    // &
    0x00,0x00,0x00,0x10,0x00,0x1E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    // '
    0x00,0x00,0x00,0x00,0x03,0xF0,0x07,0xF8,0x0C,0x0C,0x08,0x04,0x00,0x00,0x00,0x00,    // (
    0x00,0x00,0x00,0x00,0x08,0x04,0x0C,0x0C,0x07,0xF8,0x03,0xF0,0x00,0x00,0x00,0x00,    // )
    0x00,0x80,0x02,0xA0,0x03,0xE0,0x01,0xC0,0x01,0xC0,0x03,0xE0,0x02,0xA0,0x00,0x80,    // *
    0x00,0x00,0x00,0x80,0x00,0x80,0x03,0xE0,0x03,0xE0,0x00,0x80,0x00,0x80,0x00,0x00,    // +
    0x00,0x00,0x00,0x00,0x10,0x00,0x1E,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    // ,
    0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x00,    // -
    0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    // .
    0x0C,0x00,0x06,0x00,0x03,0x00,0x01,0x80,0x00,0xC0,0x00,0x60,0x00,0x30,0x00,0x00,    // /
    0x03,0xF0,0x07,0xF8,0x0C,0x0C,0x08,0xC4,0x0C,0x0C,0x07,0xF8,0x03,0xF0,0x00,0x00,    // 0
    0x00,0x00,0x08,0x10,0x08,0x18,0x0F,0xFC,0x0F,0xFC,0x08,0x00,0x08,0x00,0x00,0x00,    // 1
    0x0E,0x08,0x0F,0x0C,0x09,0x84,0x08,0xC4,0x08,0x64,0x0C,0x3C,0x0C,0x18,0x00,0x00,    // 2
    0x04,0x08,0x0C,0x0C,0x08,0x44,0x08,0x44,0x08,0x44,0x0F,0xFC,0x07,0xB8,0x00,0x00,    // 3
    0x00,0xC0,0x00,0xE0,0x00,0xB0,0x08,0x98,0x0F,0xFC,0x0F,0xFC,0x08,0x80,0x00,0x00,    // 4
    0x04,0x7C,0x0C,0x7C,0x08,0x44,0x08,0x44,0x08,0x44,0x0F,0xC4,0x07,0x84,0x00,0x00,    // 5
    0x07,0xF0,0x0F,0xF8,0x08,0x4C,0x08,0x44,0x08,0x44,0x0F,0xC0,0x07,0x80,0x00,0x00,    // 6
    0x00,0x0C,0x00,0x0C,0x0F,0x04,0x0F,0x84,0x00,0xC4,0x00,0x7C,0x00,0x3C,0x00,0x00,    // 7
    0x07,0xB8,0x0F,0xFC,0x08,0x44,0x08,0x44,0x08,0x44,0x0F,0xFC,0x07,0xB8,0x00,0x00,    // 8
    0x00,0x38,0x08,0x7C,0x08,0x44,0x08,0x44,0x0C,0x44,0x07,0xFC,0x03,0xF8,0x00,0x00,    // 9
    0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x30,0x06,0x30,0x00,0x00,0x00,0x00,0x00,0x00,    // :
    0x00,0x00,0x00,0x00,0x08,0x00,0x0E,0x30,0x06,0x30,0x00,0x00,0x00,0x00,0x00,0x00,    // ;
    0x00,0x00,0x00,0x80,0x01,0xC0,0x03,0x60,0x06,0x30,0x0C,0x18,0x08,0x08,0x00,0x00,    // <
    0x00,0x00,0x01,0x20,0x01,0x20,0x01,0x20,0x01,0x20,0x01,0x20,0x01,0x20,0x00,0x00,    // =
    0x00,0x00,0x08,0x08,0x0C,0x18,0x06,0x30,0x03,0x60,0x01,0xC0,0x00,0x80,0x00,0x00,    // >
    0x00,0x18,0x00,0x1C,0x00,0x04,0x0D,0xC4,0x0D,0xE4,0x00,0x3C,0x00,0x18,0x00,0x00,    // ?
    0x07,0xF0,0x0F,0xF8,0x08,0x08,0x0B,0xC8,0x0B,0xC8,0x0B,0xF8,0x01,0xF0,0x00,0x00,    // @
    0x0F,0xE0,0x0F,0xF0,0x00,0x98,0x00,0x8C,0x00,0x98,0x0F,0xF0,0x0F,0xE0,0x00,0x00,    // A
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x08,0x44,0x08,0x44,0x0F,0xFC,0x07,0xB8,0x00,0x00,    // B
    0x03,0xF0,0x07,0xF8,0x0C,0x0C,0x08,0x04,0x08,0x04,0x0C,0x0C,0x06,0x18,0x00,0x00,    // C
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x08,0x04,0x0C,0x0C,0x07,0xF8,0x03,0xF0,0x00,0x00,    // D
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x08,0x44,0x08,0xE4,0x0C,0x0C,0x0E,0x1C,0x00,0x00,    // E
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x08,0x44,0x00,0xE4,0x00,0x0C,0x00,0x1C,0x00,0x00,    // F
    0x03,0xF0,0x07,0xF8,0x0C,0x0C,0x08,0x84,0x08,0x84,0x07,0x8C,0x0F,0x98,0x00,0x00,    // G
    0x0F,0xFC,0x0F,0xFC,0x00,0x40,0x00,0x40,0x00,0x40,0x0F,0xFC,0x0F,0xFC,0x00,0x00,    // H
    0x00,0x00,0x00,0x00,0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x08,0x04,0x00,0x00,0x00,0x00,    // I
    0x07,0x00,0x0F,0x00,0x08,0x00,0x08,0x04,0x0F,0xFC,0x07,0xFC,0x00,0x04,0x00,0x00,    // J
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x00,0xC0,0x01,0xE0,0x0F,0x3C,0x0E,0x1C,0x00,0x00,    // K
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x08,0x04,0x08,0x00,0x0C,0x00,0x0E,0x00,0x00,0x00,    // L
    0x0F,0xFC,0x0F,0xFC,0x00,0x38,0x00,0x70,0x00,0x38,0x0F,0xFC,0x0F,0xFC,0x00,0x00,    // M
    0x0F,0xFC,0x0F,0xFC,0x00,0x38,0x00,0x70,0x00,0xE0,0x0F,0xFC,0x0F,0xFC,0x00,0x00,    // N
    0x07,0xF8,0x0F,0xFC,0x08,0x04,0x08,0x04,0x08,0x04,0x0F,0xFC,0x07,0xF8,0x00,0x00,    // O
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x08,0x44,0x00,0x44,0x00,0x7C,0x00,0x38,0x00,0x00,    // P
    0x07,0xF8,0x0F,0xFC,0x08,0x04,0x0E,0x04,0x3C,0x04,0x3F,0xFC,0x27,0xF8,0x00,0x00,    // Q
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x00,0x44,0x00,0xC4,0x0F,0xFC,0x0F,0x38,0x00,0x00,    // R
    0x06,0x18,0x0E,0x3C,0x08,0x64,0x08,0x44,0x08,0xC4,0x0F,0x9C,0x07,0x18,0x00,0x00,    // S
    0x00,0x00,0x00,0x1C,0x08,0x0C,0x0F,0xFC,0x0F,0xFC,0x08,0x0C,0x00,0x1C,0x00,0x00,    // T
    0x07,0xFC,0x0F,0xFC,0x08,0x00,0x08,0x00,0x08,0x00,0x0F,0xFC,0x07,0xFC,0x00,0x00,    // U
    0x01,0xFC,0x03,0xFC,0x06,0x00,0x0C,0x00,0x06,0x00,0x03,0xFC,0x01,0xFC,0x00,0x00,    // V
    0x07,0xFC,0x0F,0xFC,0x0E,0x00,0x03,0xC0,0x0E,0x00,0x0F,0xFC,0x07,0xFC,0x00,0x00,    // W
    0x0C,0x0C,0x0F,0x3C,0x03,0xF0,0x01,0xE0,0x03,0xF0,0x0F,0x3C,0x0C,0x0C,0x00,0x00,    // X
    0x00,0x00,0x00,0x3C,0x08,0x7C,0x0F,0xC0,0x0F,0xC0,0x08,0x7C,0x00,0x3C,0x00,0x00,    // Y
    0x0E,0x1C,0x0F,0x0C,0x09,0x84,0x08,0xC4,0x08,0x64,0x0C,0x3C,0x0E,0x1C,0x00,0x00,    // Z
    0x00,0x00,0x00,0x00,0x0F,0xFC,0x0F,0xFC,0x08,0x04,0x08,0x04,0x00,0x00,0x00,0x00,    // [
    0x00,0x38,0x00,0x70,0x00,0xE0,0x01,0xC0,0x03,0x80,0x07,0x00,0x0E,0x00,0x00,0x00,    // (\)
    0x00,0x00,0x00,0x00,0x08,0x04,0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x00,0x00,0x00,0x00,    // ]
    0x00,0x08,0x00,0x0C,0x00,0x06,0x00,0x03,0x00,0x06,0x00,0x0C,0x00,0x08,0x00,0x00,    // ^
    0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,    // _
    0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x07,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,    // `
    0x07,0x00,0x0F,0xA0,0x08,0xA0,0x08,0xA0,0x07,0xE0,0x0F,0xC0,0x08,0x00,0x00,0x00,    // a
    0x00,0x04,0x0F,0xFC,0x0F,0xFC,0x08,0x20,0x08,0x60,0x0F,0xC0,0x07,0x80,0x00,0x00,    // b
    0x07,0xC0,0x0F,0xE0,0x08,0x20,0x08,0x20,0x08,0x20,0x0C,0x60,0x04,0x40,0x00,0x00,    // c
    0x07,0x80,0x0F,0xC0,0x08,0x60,0x08,0x24,0x07,0xFC,0x0F,0xFC,0x08,0x00,0x00,0x00,    // d
    0x07,0xC0,0x0F,0xE0,0x08,0xA0,0x08,0xA0,0x08,0xA0,0x0C,0xE0,0x04,0xC0,0x00,0x00,    // e
    0x08,0x40,0x0F,0xF8,0x0F,0xFC,0x08,0x44,0x00,0x0C,0x00,0x18,0x00,0x00,0x00,0x00,    // f
    0x27,0xC0,0x6F,0xE0,0x48,0x20,0x48,0x20,0x7F,0xC0,0x3F,0xE0,0x00,0x20,0x00,0x00,    // g
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x00,0x40,0x00,0x20,0x0F,0xE0,0x0F,0xC0,0x00,0x00,    // h
    0x00,0x00,0x00,0x00,0x08,0x20,0x0F,0xEC,0x0F,0xEC,0x08,0x00,0x00,0x00,0x00,0x00,    // i
    0x00,0x00,0x30,0x00,0x70,0x00,0x40,0x00,0x40,0x20,0x7F,0xEC,0x3F,0xEC,0x00,0x00,    // j
    0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x01,0x80,0x03,0xC0,0x0E,0x60,0x0C,0x20,0x00,0x00,    // k
    0x00,0x00,0x00,0x00,0x08,0x04,0x0F,0xFC,0x0F,0xFC,0x08,0x00,0x00,0x00,0x00,0x00,    // l
    0x0F,0xE0,0x0F,0xE0,0x00,0x60,0x07,0xC0,0x00,0x60,0x0F,0xE0,0x0F,0xC0,0x00,0x00,    // m
    0x00,0x20,0x0F,0xE0,0x0F,0xC0,0x00,0x20,0x00,0x20,0x0F,0xE0,0x0F,0xC0,0x00,0x00,    // n
    0x07,0xC0,0x0F,0xE0,0x08,0x20,0x08,0x20,0x08,0x20,0x0F,0xE0,0x07,0xC0,0x00,0x00,    // o
    0x40,0x20,0x7F,0xE0,0x7F,0xC0,0x48,0x20,0x08,0x20,0x0F,0xE0,0x07,0xC0,0x00,0x00,    // p
    0x07,0xC0,0x0F,0xE0,0x08,0x20,0x48,0x20,0x7F,0xC0,0x7F,0xE0,0x40,0x20,0x00,0x00,    // q
    0x08,0x20,0x0F,0xE0,0x0F,0xC0,0x08,0x60,0x00,0x20,0x00,0xE0,0x00,0xC0,0x00,0x00,    // r
    0x04,0x40,0x0C,0xE0,0x09,0xA0,0x09,0x20,0x0B,0x20,0x0E,0x60,0x04,0x40,0x00,0x00,    // s
    0x00,0x20,0x00,0x20,0x07,0xF8,0x0F,0xFC,0x08,0x20,0x0C,0x20,0x04,0x00,0x00,0x00,    // t
    0x07,0xE0,0x0F,0xE0,0x08,0x00,0x08,0x00,0x07,0xE0,0x0F,0xE0,0x08,0x00,0x00,0x00,    // u
    0x00,0x00,0x03,0xE0,0x07,0xE0,0x0C,0x00,0x0C,0x00,0x07,0xE0,0x03,0xE0,0x00,0x00,    // v
    0x07,0xE0,0x0F,0xE0,0x0C,0x00,0x07,0x80,0x0C,0x00,0x0F,0xE0,0x07,0xE0,0x00,0x00,    // w
    0x08,0x20,0x0C,0x60,0x07,0xC0,0x03,0x80,0x07,0xC0,0x0C,0x60,0x08,0x20,0x00,0x00,    // x
    0x47,0xE0,0x4F,0xE0,0x48,0x00,0x48,0x00,0x68,0x00,0x3F,0xE0,0x1F,0xE0,0x00,0x00,    // y
    0x0C,0x60,0x0E,0x60,0x0B,0x20,0x09,0xA0,0x08,0xE0,0x0C,0x60,0x0C,0x20,0x00,0x00,    // z
    0x00,0x00,0x00,0x40,0x00,0x40,0x07,0xF8,0x0F,0xBC,0x08,0x04,0x08,0x04,0x00,0x00,    // {
    0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xBC,0x0F,0xBC,0x00,0x00,0x00,0x00,0x00,0x00,    // |
    0x00,0x00,0x08,0x04,0x08,0x04,0x0F,0xBC,0x07,0xF8,0x00,0x40,0x00,0x40,0x00,0x00,    // }
    0x00,0x80,0x00,0xC0,0x00,0x40,0x00,0xC0,0x00,0x80,0x00,0xC0,0x00,0x40,0x00,0x00,    // ~
    0x07,0x80,0x07,0xC0,0x04,0x60,0x04,0x30,0x04,0x60,0x07,0xC0,0x07,0x80,0x00,0x00,    // 0x7F
};    

#ifdef KOR_FONTS                                                                             
#ifdef KOR_FONT_MGOTH
// 16x16 Korean font (߰ü)
prog_uint8_t kor_font_mgoth[360][32] = {          
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x02,0x82,0xC2,0x7E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x02,0x02,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0xFE,0xFE,0x02,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x02,0x03,0x01,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x02,0xFE,0xFE,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x03,0x02,0x03,0x03,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xE2,0xE2,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x02,0x02,0x02,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x20,0x20,0x20,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xFE,0xFE,0x20,0xFE,0xFE,0x20,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x03,0x03,0x02,0x03,0x03,0x02,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0xC0,0x7E,0x7E,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0xFE,0x7E,0x80,0xFE,0xFE,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xF8,0xFC,0x06,0x02,0x02,0x06,0xFC,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x82,0xC2,0x7E,0x7E,0xC2,0x82,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x82,0xFE,0x7E,0x82,0xFE,0xFE,0x82,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x84,0xC4,0x7E,0x7E,0xC4,0x84,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x12,0x12,0x12,0x92,0xD2,0x7E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x02,0x02,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x22,0x22,0x22,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0xFE,0xFE,0x02,0x02,0xFE,0xFE,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x02,0x03,0x03,0x02,0x02,0x03,0x03,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0xF4,0xFC,0x0E,0x0E,0x0E,0xFC,0xF4,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x82,0xFE,0x7E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x82,0xFE,0x7E,0x02,0x02,0x82,0xFE,0x7E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xFE,0xFE,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xFE,0xFE,0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xFE,0xFE,0x82,0x82,0x82,0xFE,0xFE,0x82,0x82,0x82,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xF2,0xF2,0x92,0x92,0x92,0x92,0x92,0x92,0x9E,0x9E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xFE,0xFE,0x82,0x82,0x82,0x82,0x82,0x82,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xFE,0xFE,0x90,0x90,0x90,0x90,0x90,0x90,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xFE,0xFE,0x90,0x90,0xFE,0xFE,0x90,0x90,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x40,0x60,0x30,0x18,0x0E,0x0E,0x18,0x30,0x60,0x40,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x40,0x60,0x30,0x1E,0x5E,0x70,0x30,0x1E,0x1E,0x30,0x60,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x38,0x7C,0xC6,0x82,0x82,0x82,0x82,0xC6,0x7C,0x38,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x82,0xC2,0x62,0x32,0x1E,0x1E,0x32,0x62,0xC2,0x82,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x42,0x62,0x32,0x1E,0x5E,0x72,0x32,0x1E,0x1E,0x32,0x62,0x42,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x84,0xC4,0x64,0x34,0x1E,0x1E,0x34,0x64,0xC4,0x84,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x92,0xFE,0x7E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xFE,0xFE,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x82,0x82,0xFE,0xFE,0x82,0x82,0xFE,0xFE,0x82,0x82,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x74,0xFC,0x8C,0x8E,0x8E,0x8C,0xFC,0x74,0x04,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x82,0xFE,0x7E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x82,0xFE,0x7E,0x02,0x02,0x82,0xFE,0x7E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x7E,0x7E,0x48,0x48,0x48,0x48,0x48,0x48,0x7E,0x7E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x7E,0x7E,0x48,0x48,0x7E,0x7E,0x48,0x48,0x7E,0x7E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x20,0x30,0x18,0x0E,0x2E,0x38,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x18,0x3C,0x66,0x42,0x42,0x42,0x42,0x66,0x3C,0x18,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x42,0x62,0x32,0x1A,0x0E,0x0E,0x1A,0x32,0x62,0x42,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x42,0x62,0x32,0x1E,0x5E,0x72,0x32,0x1E,0x1E,0x32,0x62,0x42,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x44,0x64,0x34,0x1C,0x0E,0x0E,0x1C,0x34,0x64,0x44,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x92,0xFE,0x7E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x22,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x34,0x7C,0x4C,0x4E,0x4E,0x4C,0x7C,0x34,0x04,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x02,0x02,0x02,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x82,0xFE,0x7E,0x82,0xFE,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x82,0x82,0x82,0x82,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x82,0xFE,0xFE,0x82,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xF2,0xF2,0x92,0x92,0x92,0x9E,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x82,0x82,0x82,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x90,0x90,0x90,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xFE,0xFE,0x90,0xFE,0xFE,0x90,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x60,0x30,0x1E,0x1E,0x30,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x80,0xC0,0x7E,0xBE,0xC0,0x7E,0x7E,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x38,0x7C,0xC6,0x82,0x82,0xC6,0x7C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x42,0x62,0x32,0x1E,0x1E,0x32,0x62,0x42,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x82,0xC2,0x7E,0xBE,0xC2,0x7E,0x7E,0xC2,0x82,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x84,0xC4,0x64,0x3E,0x3E,0x64,0xC4,0x84,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x12,0x12,0x12,0x12,0x12,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x92,0x92,0x92,0x92,0x92,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x82,0xFE,0xFE,0x82,0xFE,0xFE,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x74,0xFC,0x8E,0x8E,0xFC,0x74,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x02,0x02,0x42,0x7E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x42,0x7E,0x3E,0x42,0x7E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7E,0x7E,0x48,0x48,0x48,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x7E,0x7E,0x48,0x7E,0x7E,0x48,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x20,0x30,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x20,0x30,0x1E,0x2E,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x18,0x3C,0x66,0x42,0x42,0x66,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x42,0x62,0x32,0x1E,0x1E,0x32,0x62,0x42,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x22,0x32,0x1E,0x2E,0x32,0x1E,0x1E,0x32,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x44,0x64,0x34,0x1E,0x1E,0x34,0x64,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x12,0x12,0x12,0x12,0x52,0x7E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x22,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x34,0x7C,0x4E,0x4E,0x7C,0x34,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x82,0xC2,0x62,0x3E,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x82,0xC2,0x7E,0xBE,0xC2,0x7E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x82,0x82,0x82,0x82,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x82,0xFE,0xFE,0x82,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xF2,0xF2,0x92,0x92,0x92,0x9E,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x82,0x82,0x82,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x90,0x90,0x90,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xFE,0xFE,0x90,0xFE,0xFE,0x90,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x80,0xC0,0x60,0x3E,0x3E,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x60,0x3E,0x5E,0x60,0x3E,0x3E,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x38,0x7C,0xC6,0x82,0x82,0xC6,0x7C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x82,0xC2,0x62,0x3E,0x3E,0x62,0xC2,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x82,0xC2,0x7E,0xBE,0xC2,0x7E,0x7E,0xC2,0x82,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x84,0xC4,0x64,0x3E,0x3E,0x64,0xC4,0x84,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x12,0x12,0x92,0xD2,0x72,0x3E,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x92,0x92,0x92,0x92,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x82,0xFE,0xFE,0x82,0x82,0xFE,0xFE,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x74,0xFC,0x8E,0x8E,0xFC,0x74,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x22,0x3E,0x1E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x22,0x3E,0x1E,0x02,0x02,0x22,0x3E,0x1E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x3E,0x3E,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x20,0x30,0x18,0x0E,0x2E,0x38,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x32,0x1A,0x0E,0x06,0x06,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x22,0x32,0x1A,0x0E,0x2E,0x3A,0x1A,0x0E,0x0E,0x1A,0x32,0x22,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x24,0x34,0x1C,0x0C,0x06,0x06,0x0C,0x1C,0x34,0x24,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x2A,0x3E,0x1E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x22,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x14,0x3C,0x2C,0x2C,0x2E,0x2E,0x2C,0x2C,0x3C,0x14,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x02,0x02,0x22,0x3E,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x22,0x3E,0x1E,0x22,0x3E,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x3E,0x3E,0x28,0x3E,0x3E,0x28,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x20,0x30,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x20,0x30,0x1E,0x2E,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x22,0x32,0x1A,0x0E,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x22,0x32,0x1E,0x2E,0x32,0x1E,0x1E,0x32,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x24,0x34,0x1C,0x0E,0x0E,0x1C,0x34,0x24,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x2A,0x3E,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x22,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x14,0x3C,0x2E,0x2E,0x2E,0x3C,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x90,0x90,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x90,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x20,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x90,0x90,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x90,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x08,0x08,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,0x00,
     0x00,0x00,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x3F,0x3F,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x1F,0x1F,0x01,0x01,0x05,0x05,0x04,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x01,0x01,0x1F,0x1F,0x01,0x05,0x05,0x05,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x1F,0x1F,0x01,0x01,0x01,0x01,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x3F,0x3F,0x01,0x01,0x3F,0x3F,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x90,0x90,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x90,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x20,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x90,0x90,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x90,0x90,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,0x00,
     0x00,0x00,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x04,0x00,0x3F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x08,0x08,0x08,0x0F,0x0F,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x3F,0x3F,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x1F,0x1F,0x01,0x01,0x05,0x05,0x04,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x01,0x01,0x1F,0x1F,0x01,0x05,0x05,0x05,0x3F,0x3F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x1F,0x1F,0x01,0x01,0x01,0x01,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x3F,0x3F,0x01,0x01,0x3F,0x3F,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x48,0x48,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x24,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x28,0x28,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x28,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x10,0x10,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0x80,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0xE0,0xE0,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x90,0x10,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x90,0x90,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x48,0x48,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x24,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0x28,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0x00,0xFE,0xFE,0x10,0x10,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x80,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0xE0,0xE0,0x80,0x80,0xE0,0xE0,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x90,0x10,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x90,0x90,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x3E,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x1E,0x20,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x22,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x00,0x22,0x32,0x1E,0x1E,0x32,0x22,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x14,0x3E,0x2E,0x2E,0x3E,0x14,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x00,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x00,0x3E,0x3E,0x22,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x00,0x3E,0x3E,0x28,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x0E,0x20,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x22,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x14,0x3E,0x2E,0x2E,0x3E,0x14,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x28,0x3E,0x1E,0x20,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x20,0x30,0x18,0x2E,0x3E,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x22,0x32,0x1A,0x0E,0x06,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x24,0x34,0x1C,0x0E,0x06,0x0E,0x1C,0x34,0x24,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x22,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x14,0x3C,0x2C,0x2E,0x2E,0x2E,0x2C,0x3C,0x14,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x3E,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x1E,0x20,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x22,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x00,0x22,0x32,0x1E,0x1E,0x32,0x22,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x14,0x3E,0x2E,0x2E,0x3E,0x14,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x00,0x3E,0x3E,0x22,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x00,0x3E,0x3E,0x28,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x0E,0x20,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x22,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x14,0x3C,0x2E,0x2E,0x3C,0x14,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x28,0x3E,0x1E,0x20,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x20,0x30,0x18,0x2E,0x3E,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x22,0x32,0x1A,0x0E,0x06,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x24,0x34,0x1C,0x0E,0x06,0x0E,0x1C,0x34,0x24,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x22,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x14,0x3C,0x2C,0x2E,0x2E,0x2E,0x2C,0x3C,0x14,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x3E,0x3E,0x02,0x02,0x02,0x3E,0x3E,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x3E,0x00,0x20,0x30,0x1E,0x1E,0x30,0x20},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x22,0x22,0x20,0x22,0x22,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x00,0x22,0x32,0x1E,0x1E,0x32,0x22,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x14,0x3E,0x2E,0x2E,0x3E,0x14,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x00,0x02,0x02,0x02,0x3E,0x3E,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x00,0x3E,0x3E,0x22,0x3E,0x3E,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x00,0x3E,0x3E,0x28,0x3E,0x3E,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x00,0x20,0x30,0x1E,0x1E,0x30,0x20},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x22,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x14,0x3E,0x2E,0x2E,0x3E,0x14,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x3E,0x3E,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x28,0x28,0x28,0x3E,0x3E,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3E,0x3E,0x28,0x3E,0x3E,0x00,0x20,0x30,0x1E,0x1E,0x30,0x20},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x06,0x0C,0x18,0x30,0x20,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x30,0x18,0x0E,0x2E,0x38,0x18,0x0E,0x0E,0x18,0x30,0x20},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x3E,0x1C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x22,0x32,0x1A,0x0E,0x06,0x06,0x0E,0x1A,0x32,0x22,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x24,0x34,0x1C,0x0C,0x06,0x06,0x0C,0x1C,0x34,0x24,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x22,0x22,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x22,0x22,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x14,0x3C,0x2C,0x2C,0x2E,0x2E,0x2C,0x2C,0x3C,0x14,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x3E,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x1E,0x20,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x22,0x32,0x1E,0x1E,0x32,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x14,0x3E,0x2E,0x2E,0x3E,0x14,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x00,0x3E,0x3E,0x22,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x00,0x3E,0x3E,0x28,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x0E,0x20,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2E,0x2E,0x22,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2E,0x2E,0x14,0x3E,0x2E,0x2E,0x3E,0x14,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x28,0x3E,0x1E,0x20,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x20,0x30,0x18,0x0E,0x2E,0x38,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x22,0x32,0x1A,0x0E,0x06,0x06,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x24,0x34,0x1C,0x0C,0x06,0x06,0x0C,0x1C,0x34,0x24,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x22,0x22,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x14,0x3C,0x2C,0x2C,0x2E,0x2E,0x2C,0x2C,0x3C,0x14,0x00,0x00,0x00}
};
#endif

#ifdef KOR_FONT_IYAGI
// 16x16 Korean font  (̾߱ü)
prog_uint8_t kor_font_iyagi[360][32] = {          
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x08,0x08,0x08,0x88,0xC8,0x78,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x02,0x02,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0x08,0xC8,0xF8,0x38,0xC8,0xF8,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x02,0x01,0x01,0x02,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0xF8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0xF8,0xF8,0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x03,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0xF8,0xF8,0x08,0xF8,0xF8,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x03,0x02,0x01,0x03,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xC8,0xC8,0x48,0x48,0x48,0x78,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0xF8,0xF8,0x08,0x08,0x08,0xF8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x10,0xF0,0xF0,0x40,0x40,0x48,0xF8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x03,0x02,0x02,0x02,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x10,0xF0,0xF0,0x40,0xF0,0xF0,0x48,0xF8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x03,0x03,0x02,0x03,0x03,0x02,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0xC4,0x7C,0xFC,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x02,0x02,0x01,0x01,0x00,0x00,0x01,0x03,0x02,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xF8,0x78,0x80,0x80,0x78,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x02,0x03,0x01,0x00,0x03,0x03,0x00,0x01,0x03,0x02,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xE0,0xF0,0x18,0x08,0x08,0x18,0xF0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0x08,0x08,0x88,0xC8,0x78,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x02,0x02,0x01,0x01,0x00,0x01,0x03,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0x88,0xC8,0xF8,0xB8,0xC8,0xF8,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x02,0x03,0x01,0x02,0x03,0x01,0x00,0x01,0x03,0x02,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x10,0x10,0x14,0x94,0xD4,0xF4,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x02,0x02,0x01,0x01,0x00,0x01,0x03,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x28,0x28,0x28,0x28,0xA8,0xE8,0x78,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x02,0x02,0x02,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0xF8,0xF8,0x48,0x48,0x48,0x48,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x08,0x08,0xF8,0xF8,0x08,0x08,0xF8,0xF8,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,
     0x02,0x02,0x03,0x03,0x02,0x02,0x03,0x03,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0xC8,0xE8,0x2C,0x2C,0x2C,0xE8,0xC8,0x08,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x03,0x02,0x02,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0xFC,0x7C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x04,0x04,0xFC,0x7C,0x04,0x04,0x04,0xFC,0x7C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x3C,0x7C,0x44,0x44,0x44,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x50,0x50,0x54,0x7C,0x7C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x7C,0x7C,0x50,0x50,0x7C,0x7C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x40,0x60,0x34,0x1C,0x1C,0x10,0x20,0x60,0xC0,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x80,0xC0,0x60,0x3C,0x1C,0xB0,0xC0,0x60,0x3C,0x3C,0x60,0xC0,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x44,0x44,0x7C,0x38,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x84,0x44,0x44,0x24,0x24,0x14,0x3C,0x2C,0x44,0xC0,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x44,0x64,0x34,0x1C,0x1C,0x64,0x64,0x1C,0x1C,0x34,0x64,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x88,0x48,0x48,0x6A,0x3A,0x1A,0x3A,0x28,0x48,0xC8,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0xFC,0xFC,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x44,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x34,0x7C,0x4E,0x4E,0x4E,0x4E,0x7C,0x34,0x04,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0xFC,0x7C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x3C,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x3C,0x7C,0x44,0x44,0x44,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x50,0x50,0x54,0x7C,0x7C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x7C,0x7C,0x50,0x50,0x7C,0x7C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x40,0x40,0x20,0x30,0x1A,0x0E,0x0E,0x08,0x10,0x30,0x60,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x60,0x30,0x1E,0x0E,0x18,0x60,0x18,0x0E,0x1E,0x30,0x60,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x40,0x42,0x22,0x22,0x12,0x12,0x0A,0x1E,0x16,0x22,0x60,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x44,0x64,0x34,0x1C,0x1C,0x64,0x64,0x1C,0x1C,0x34,0x64,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x40,0x44,0x24,0x24,0x36,0x1E,0x0E,0x1E,0x14,0x24,0x64,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0xFC,0x7C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x44,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x34,0x7C,0x4E,0x4E,0x4E,0x4E,0x7C,0x34,0x04,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x04,0x04,0x04,0x04,0xFC,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x04,0xFC,0x7C,0x04,0x04,0xFC,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x44,0x44,0x3C,0x7C,0x44,0x44,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0x7C,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0x7C,0x50,0x50,0x54,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0x7C,0x50,0x7C,0x7C,0x50,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x80,0x40,0x60,0x34,0x1C,0x1C,0x20,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x80,0xC0,0x7C,0x3C,0xE0,0xE0,0x3C,0x7C,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x7C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x44,0x44,0x24,0x34,0x1C,0x2C,0x64,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x64,0x34,0x3C,0x6C,0x34,0x3C,0x6C,0x44,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x88,0x88,0x4C,0x6C,0x3C,0x58,0xC8,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0xFC,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x34,0x7C,0x4E,0x4E,0x4E,0x7C,0x34,0x04,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x04,0x04,0x04,0x04,0xFC,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x04,0x7C,0x3C,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x44,0x44,0x3C,0x7C,0x44,0x44,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0x7C,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0x7C,0x50,0x50,0x54,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0x7C,0x50,0x7C,0x7C,0x50,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x20,0x30,0x1A,0x0E,0x0E,0x10,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x60,0x3C,0x1C,0x70,0x70,0x1C,0x3C,0x60,0x40,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x7C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x44,0x24,0x24,0x14,0x1C,0x2C,0x64,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x44,0x64,0x34,0x3C,0x6C,0x74,0x3C,0x6C,0x44,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x44,0x44,0x24,0x26,0x16,0x1E,0x2C,0x64,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x14,0x14,0x14,0x14,0x14,0xFC,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x34,0x7C,0x4E,0x4E,0x4E,0x7C,0x34,0x04,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x04,0x84,0xC4,0x64,0x3C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x84,0xE4,0x7C,0x9C,0xE4,0x7C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0xFC,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0xFC,0x84,0x84,0x84,0x84,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0xFC,0x84,0x7C,0xFC,0x84,0x84,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xE4,0xE4,0x24,0x24,0x24,0x3C,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0xFC,0xFC,0x84,0x84,0x84,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0xFC,0xFC,0x90,0x90,0x94,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0xFC,0xFC,0x90,0xFC,0xFC,0x90,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x80,0xE4,0x3C,0x7C,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x80,0xC0,0x7C,0x1C,0xE0,0x1C,0x7C,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x78,0xFC,0x84,0x84,0x84,0xFC,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x84,0x84,0x44,0x64,0x34,0x5C,0xCC,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x84,0xC4,0x64,0xFC,0xDC,0x64,0xFC,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0x08,0x8C,0xCC,0x6C,0xF8,0x98,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x14,0x14,0x94,0xD4,0x74,0x3C,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0xFC,0xFC,0x24,0x24,0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x84,0xFC,0xFC,0x84,0x84,0xFC,0xFC,0x84,0x84,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x74,0xFC,0x8E,0x8E,0xFC,0x74,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x04,0x04,0x7C,0x3C,0x04,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x1C,0x3C,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x1C,0x3C,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x1C,0x3C,0x24,0x24,0x24,0x1C,0x3C,0x24,0x24,0x24,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x3C,0x3C,0x24,0x24,0x24,0x24,0x24,0x3C,0x3C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x50,0x50,0x50,0x54,0x7C,0x7C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x7C,0x7C,0x50,0x50,0x7C,0x7C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x40,0x40,0x20,0x30,0x1A,0x0E,0x0E,0x08,0x10,0x30,0x60,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x60,0x30,0x1E,0x0E,0x58,0x70,0x30,0x1E,0x1E,0x30,0x60,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x44,0x7C,0x38,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x44,0x44,0x44,0x24,0x24,0x14,0x3C,0x2C,0x44,0x40,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x44,0x64,0x34,0x1C,0x1C,0x64,0x64,0x1C,0x1C,0x34,0x64,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x44,0x44,0x24,0x34,0x1E,0x0E,0x1E,0x34,0x24,0x44,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x7C,0x3C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x44,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x34,0x7C,0x4E,0x4E,0x4E,0x4E,0x7C,0x34,0x04,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x04,0x7C,0x3C,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x44,0x44,0x3C,0x7C,0x44,0x44,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0x7C,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0x7C,0x50,0x50,0x54,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x7C,0x7C,0x50,0x7C,0x7C,0x50,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x20,0x30,0x1A,0x0E,0x0E,0x10,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x60,0x3C,0x1C,0x70,0x70,0x1C,0x3C,0x60,0x40,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x7C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x44,0x24,0x24,0x14,0x1C,0x2C,0x64,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x44,0x64,0x34,0x3C,0x6C,0x34,0x3C,0x6C,0x44,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x44,0x44,0x24,0x26,0x16,0x1E,0x2C,0x64,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x14,0x14,0x14,0x14,0x14,0xFC,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x34,0x7C,0x4E,0x4E,0x4E,0x7C,0x34,0x04,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x40,0x40,0x40,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x42,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x20,0x20,0x20,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x01,0x01,0x01},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x22,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1F,0x01,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x42,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x44,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xA0,0xA0,0xA2,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xA0,0xA0,0xA4,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x80,0x80,0x80,
     0x00,0x04,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x00,0x7F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x42,0xFE,0xFE,0x00,
     0x00,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x00,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x04,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x04,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x08,0x08,0x08,0x0F,0x0F,0x08,0x08,0x09,0x0F,0x0F,0x08,0x08,0x08,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x7F,0x3F,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x3F,0x1F,0x01,0x01,0x05,0x05,0x04,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x01,0x01,0x01,0x3F,0x1F,0x01,0x05,0x05,0x04,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x3F,0x1F,0x01,0x01,0x01,0x01,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x7F,0x3F,0x01,0x01,0x7F,0x3F,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x02,0x02,0x02,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x40,0x40,0x40,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x42,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x20,0x20,0x20,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x01,0x01,0x01},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x22,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1F,0x01,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x42,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xA0,0xA0,0xA2,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xA4,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x08,0x08,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x80,0x80,0x80,
     0x00,0x04,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x00,0x7F,0x3F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x42,0xFE,0xFE,0x00,
     0x00,0x04,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x00,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x04,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x04,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x08,0x08,0x08,0x08,0x0F,0x0F,0x08,0x08,0x0F,0x0F,0x08,0x08,0x08,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x7F,0x3F,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x3F,0x1F,0x01,0x01,0x05,0x05,0x04,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x01,0x01,0x01,0x1F,0x0F,0x01,0x05,0x05,0x04,0x3F,0x1F,0x00,0x7F,0x3F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x3F,0x1F,0x01,0x01,0x01,0x01,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x7F,0x3F,0x01,0x01,0x7F,0x3F,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x02,0x02,0x02,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x20,0x20,0x20,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x22,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x50,0x50,0x50,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x52,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x20,0x22,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x24,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x50,0x52,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x54,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x20,0x20,0x20,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x03,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x22,0xFE,0xFE,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x00,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x40,0x40,0x40,0xC0,0xC0,0x40,0x40,0x40,0x40,0x04,0xFC,0xFC,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x07,0x03,0x00,0x00,0x01,0x01,0x01,0x07,0x03,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x44,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x01,0x01,0x01,0x07,0x03,0x01,0x01,0x01,0x00,0x07,0x03,0x00,0x07,0x03,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x07,0x07,0x01,0x01,0x07,0x07,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x20,0x20,0x20,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x22,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x50,0x50,0x50,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFC,0xFC,0x52,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x22,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x50,0x52,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x20,0x20,0x20,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x03,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x04,0xFC,0xFC,0x22,0xFE,0xFE,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x00,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x07,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x01,0x01,0x03,0x03,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xA0,0x24,0xFC,0xFC,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x02,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x07,0x07,0x01,0x01,0x07,0x07,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x3C,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x3C,0x40,0x60,0x3C,0x1C,0x70,0x60,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x44,0x64,0x3C,0x3C,0x64,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x44,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x60,0x3C,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x54,0x54,0x54,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x18,0x44,0x7C,0x7C,0x44,0x7C,0x7C,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x7C,0x7C,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x50,0x54,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x60,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x40,0x40,0x20,0x30,0x1C,0x0C,0x10,0x30,0x60,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x40,0x60,0x30,0x1C,0x5C,0x70,0x30,0x1C,0x1C,0x30,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x44,0x7C,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x44,0x44,0x24,0x34,0x1C,0x1C,0x34,0x24,0x44,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x1C,0x1C,0x38,0x28,0x48,0x48,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0x7C,0x3C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x08,0x28,0x78,0x5C,0x5C,0x5C,0x5C,0x78,0x28,0x08,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x3C,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x3C,0x40,0x60,0x3C,0x1C,0x70,0x60,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x44,0x64,0x3C,0x3C,0x64,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x04,0x04,0x7C,0x3C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x44,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x60,0x3C,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x54,0x54,0x54,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x18,0x44,0x7C,0x7C,0x44,0x7C,0x7C,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x7C,0x7C,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x50,0x54,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x60,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x40,0x40,0x20,0x30,0x1C,0x0C,0x10,0x30,0x60,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x40,0x60,0x30,0x1C,0x5C,0x70,0x30,0x1C,0x1C,0x30,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x44,0x7C,0x38,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x44,0x44,0x24,0x34,0x1C,0x1C,0x34,0x24,0x44,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x1C,0x1C,0x38,0x28,0x48,0x48,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0x7C,0x3C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x08,0x28,0x78,0x5C,0x5C,0x5C,0x5C,0x78,0x28,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7C,0x3C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x7C,0x3C,0x04,0x04,0x04,0x7C,0x3C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x7C,0x3C,0x40,0x60,0x3C,0x1C,0x70,0x60},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x00,0x44,0x64,0x3C,0x3C,0x64,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x04,0x04,0x7C,0x3C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x44,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x60,0x3C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x54,0x54,0x54,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x18,0x44,0x7C,0x7C,0x44,0x7C,0x7C,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x50,0x50,0x54,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x60,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x20,0x30,0x1C,0x0C,0x10,0x30,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x40,0x60,0x30,0x1C,0x5C,0x70,0x30,0x1C,0x1C,0x30,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x44,0x7C,0x38,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x44,0x44,0x24,0x34,0x1C,0x1C,0x34,0x24,0x44,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x1C,0x1C,0x38,0x28,0x48,0x48,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x7C,0x3C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x08,0x28,0x78,0x5C,0x5C,0x5C,0x5C,0x78,0x28,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x7C,0x3C,0x00,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x3C,0x40,0x60,0x3C,0x1C,0x70,0x60,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x00,0x44,0x64,0x3C,0x3C,0x64,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x3C,0x7C,0x40,0x40,0x40,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x08,0x38,0x78,0x48,0x48,0x48,0x48,0x48,0x48,0x48,0x48,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x54,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x04,0x04,0x04,0x7C,0x3C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x40,0x60,0x3C,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x54,0x54,0x54,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x34,0x74,0x54,0x5C,0x18,0x44,0x7C,0x7C,0x44,0x7C,0x7C,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x34,0x74,0x54,0x5C,0x5C,0x00,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x7C,0x7C,0x50,0x50,0x50,0x50,0x50,0x54,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x60,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x40,0x40,0x20,0x30,0x1C,0x0C,0x10,0x30,0x60,0x40,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x40,0x60,0x30,0x1C,0x1C,0x30,0x60,0x60,0x30,0x1C,0x1C,0x30,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x44,0x7C,0x38,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x44,0x44,0x24,0x34,0x1C,0x1C,0x34,0x24,0x44,0x44,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x1C,0x1C,0x38,0x28,0x48,0x48,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x7C,0x3C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x44,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x08,0x28,0x78,0x5C,0x5C,0x5C,0x5C,0x78,0x28,0x08,0x00,0x00,0x00}
};
#endif

#ifdef KOR_FONT_PILGI
// 16x16 Korean font data (ʱü)
prog_uint8_t kor_font_pilgi[360][32] = {          
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x08,0x08,0x08,0x08,0x08,0x88,0xC8,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x06,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x08,0x08,0x08,0xC8,0xF8,0x30,0x90,0xF0,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x07,0x03,0x00,0x06,0x07,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xF8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x03,0x07,0x04,0x04,0x04,0x04,0x06,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00},
    {0x08,0x08,0xC8,0xF8,0x38,0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x03,0x07,0x04,0x04,0x04,0x04,0x06,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00},
    {0xC8,0xF8,0x38,0x08,0xC8,0xF8,0x38,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x03,0x07,0x04,0x06,0x03,0x07,0x04,0x06,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0x88,0xC8,0x58,0x70,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x03,0x07,0x04,0x04,0x04,0x06,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xFC,0xFC,0x08,0x08,0x18,0x90,0xF0,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x03,0x03,0x00,0x02,0x03,0x03,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xFC,0xFC,0x80,0xC0,0x40,0x40,0xF8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x07,0x07,0x01,0x03,0x06,0x04,0x07,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xF0,0xF0,0x80,0xF0,0xF0,0x80,0x80,0xF0,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x03,0x07,0x04,0x07,0x07,0x04,0x06,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xC0,0xF0,0xF8,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x04,0x06,0x03,0x01,0x00,0x01,0x03,0x06,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x80,0xE0,0xF8,0x98,0xC0,0xF0,0xB8,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x02,0x03,0x01,0x02,0x03,0x01,0x00,0x01,0x03,0x02,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xC0,0xE0,0x30,0x10,0x10,0x30,0x20,0xE0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x03,0x02,0x02,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0x08,0x08,0x18,0x90,0xF0,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x04,0x02,0x03,0x01,0x03,0x06,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0xC8,0xE8,0xB8,0x90,0xD0,0x70,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x07,0x07,0x00,0x07,0x07,0x01,0x03,0x06,0x04,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x10,0x10,0x12,0x16,0x94,0xF4,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x04,0x04,0x02,0x03,0x01,0x03,0x06,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x80,0x88,0x88,0x88,0x98,0xD0,0xF0,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x06,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x08,0xC8,0xF8,0x78,0x48,0x48,0x48,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x03,0x07,0x04,0x04,0x04,0x04,0x06,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00},
    {0x08,0x08,0xF8,0xF8,0x08,0x88,0xF8,0x78,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x02,0x02,0x03,0x03,0x03,0x03,0x02,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x10,0x10,0x94,0xD4,0x5C,0x7C,0xE0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x03,0x07,0x04,0x04,0x06,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x0C,0x08,0x08,0xF8,0xF0,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x07,0x03,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x04,0x04,0x84,0xC4,0x7C,0x38,0x08,0x08,0x08,0x88,0xF8,0x70,0x00,0x00,
     0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x04,0x34,0x7C,0x4C,0x44,0x44,0x44,0x44,0x44,0x40,0x40,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x34,0x7C,0x4C,0x44,0x44,0x74,0x7C,0x4C,0x44,0x64,0x24,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x28,0x7A,0x5A,0x4A,0x4A,0x4A,0x4E,0x6C,0x20,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x7C,0x7C,0x08,0x44,0x44,0x44,0x64,0x7C,0x58,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x7E,0x7E,0x30,0x78,0x48,0x48,0x58,0x7C,0x3C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3C,0x7C,0x50,0x50,0x7C,0x7C,0x50,0x50,0x7C,0x3C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0xC0,0x60,0x30,0x18,0x1C,0x34,0x20,0x60,0x40,0x40,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x40,0x70,0x38,0x3C,0x64,0x60,0x30,0x18,0x3C,0x64,0x40,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x30,0x78,0xCC,0x84,0x84,0x8C,0xC8,0x78,0x30,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x04,0x84,0xE4,0x74,0x3C,0x28,0x60,0x40,0xC0,0x80,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x44,0x44,0x64,0x34,0x7C,0x4C,0x64,0x34,0x3C,0x28,0x60,0x40,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x05,0x87,0xC6,0x64,0x3C,0x38,0x60,0x40,0xC0,0x80,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x44,0x44,0x44,0x44,0x44,0x44,0x4C,0x48,0x48,0xF8,0xF0,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x07,0x03,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x40,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x04,0x44,0x7C,0x7C,0x44,0x64,0x7C,0x5C,0x44,0x04,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x64,0xF4,0x94,0x9D,0x8D,0xCF,0x7E,0x30,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x43,0x62,0x3E,0x1C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x02,0x22,0x3E,0x1C,0x04,0x44,0x64,0x3C,0x18,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x0F,0x1F,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x0A,0x1E,0x16,0x12,0x12,0x12,0x12,0x10,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x0E,0x1E,0x12,0x12,0x12,0x0E,0x1E,0x12,0x12,0x12,0x12,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x14,0x3D,0x2D,0x25,0x25,0x27,0x36,0x10,0x10,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3F,0x3F,0x00,0x21,0x21,0x31,0x3B,0x2E,0x04,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3F,0x3F,0x08,0x1C,0x34,0x24,0x2C,0x3E,0x1E,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x1F,0x3F,0x28,0x38,0x1C,0x1F,0x3F,0x28,0x38,0x1E,0x0E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x0F,0x1B,0x10,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x20,0x30,0x1C,0x0F,0x3B,0x30,0x18,0x0E,0x1F,0x31,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x0C,0x1E,0x33,0x21,0x21,0x23,0x32,0x1E,0x0C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x01,0x01,0x01,0x21,0x31,0x19,0x0D,0x1F,0x12,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x21,0x31,0x19,0x1D,0x37,0x23,0x31,0x19,0x1F,0x36,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x02,0x23,0x33,0x1B,0x1F,0x14,0x30,0x20,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x11,0x13,0x52,0x72,0x3E,0x1C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x01,0x01,0x1D,0x3F,0x27,0x25,0x25,0x25,0x25,0x35,0x10,0x10,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x01,0x21,0x2F,0x3F,0x31,0x31,0x39,0x2D,0x25,0x31,0x10,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x32,0x7A,0x4B,0x4F,0x47,0x67,0x3E,0x18,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x08,0x08,0x08,0x18,0x90,0xF0,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x04,0x44,0x7C,0x38,0x08,0x98,0xF0,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x3E,0x7E,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x34,0x7C,0x4C,0x44,0x44,0x64,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x34,0x7C,0x4C,0x74,0x7C,0x4C,0x64,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x50,0xF4,0xB4,0x94,0x9C,0x98,0xC0,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x7C,0x7C,0x04,0x44,0x44,0x6C,0x78,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xFC,0xFC,0x60,0xD0,0x90,0xFC,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x7C,0xFC,0xA0,0xA0,0xFC,0xFC,0xA0,0xF8,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xC0,0xF0,0x3C,0x1C,0x30,0x20,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xC0,0xF0,0x3C,0xBC,0xE0,0x70,0x3C,0x6C,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x30,0x78,0x48,0x4C,0x44,0x4C,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x84,0xC4,0x64,0x3C,0x78,0x40,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xC4,0xE4,0x3C,0x78,0xC4,0xE4,0x3C,0x78,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x84,0xC5,0x67,0x3E,0x78,0x40,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x48,0x48,0x48,0x58,0xD0,0xF0,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x04,0x74,0xFC,0x9C,0x94,0x94,0xD4,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x84,0xFC,0xFC,0xC4,0xE4,0xB4,0x94,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x64,0xF4,0x96,0x9E,0xCC,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x08,0x08,0x08,0x18,0x90,0xF0,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x08,0x08,0x98,0xF0,0x70,0x10,0x90,0xF0,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x3C,0x7C,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x34,0x7C,0x4C,0x44,0x44,0x64,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x34,0x7C,0x4C,0x74,0x7C,0x4C,0x64,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x20,0x74,0x54,0x5C,0x48,0x60,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7C,0x7C,0x04,0x44,0x6C,0x78,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7C,0x7C,0x20,0x70,0x50,0x7C,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x3C,0x7C,0x50,0x7C,0x7C,0x50,0x7C,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x60,0x78,0x1C,0x14,0x30,0x20,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x60,0x78,0x3C,0x64,0x60,0x38,0x3C,0x64,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x30,0x78,0x48,0x4C,0x44,0x4C,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x44,0x64,0x34,0x1C,0x38,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x64,0x74,0x3C,0x6C,0x64,0x34,0x3C,0x6C,0x48,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x45,0x67,0x36,0x1C,0x38,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x20,0x24,0x24,0x24,0xAC,0xE8,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x04,0x34,0x7C,0x5C,0x54,0x54,0x54,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x44,0x7C,0x7C,0x64,0x74,0x54,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x24,0x74,0x56,0x5E,0x4C,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x04,0x04,0x84,0x84,0xC4,0x64,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x04,0x84,0xE4,0x7C,0x18,0xC8,0xF8,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xFC,0xFC,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0xE4,0xFC,0x1C,0x04,0x04,0x84,0x84,0xC0,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xE4,0xFC,0x1C,0x84,0xE4,0xFC,0x1C,0x04,0x84,0xC0,0x40,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x84,0xC4,0x64,0x3C,0x18,0x80,0x80,0xC0,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xFC,0xFC,0x04,0x04,0x84,0xCC,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0xFE,0xFE,0xE0,0xB0,0x10,0xFC,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xFC,0xFC,0x20,0xFC,0xFC,0x20,0xA0,0xFC,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x80,0xC0,0x70,0x3C,0x3E,0x62,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x80,0xC0,0x70,0xBC,0xEC,0x60,0x38,0x7C,0xC4,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x30,0x78,0xCC,0x84,0x84,0x8C,0xC8,0x78,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x04,0x04,0x84,0xC4,0x64,0x7C,0xD8,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x02,0xC2,0xF2,0x3E,0xEC,0xC4,0x64,0xFC,0x98,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0x04,0x85,0xC5,0x67,0x7E,0xD8,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x20,0x22,0x22,0xA2,0xE6,0x74,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x04,0xE4,0xFC,0x1C,0x14,0x14,0x94,0x80,0xC0,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x84,0xFC,0xFC,0xC4,0xFC,0xBC,0xC4,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x08,0x88,0xC9,0x69,0x3B,0x1E,0xFC,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x03,0x42,0x62,0x3E,0x1C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x22,0x32,0x1E,0x0C,0x04,0x44,0x64,0x3C,0x18,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x0E,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x1A,0x3E,0x26,0x22,0x22,0x22,0x22,0x30,0x10,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x1A,0x3E,0x26,0x22,0x32,0x1A,0x3E,0x26,0x22,0x32,0x12,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x10,0x39,0x29,0x2D,0x25,0x27,0x22,0x30,0x10,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x1F,0x1F,0x01,0x11,0x11,0x1B,0x1E,0x14,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x1F,0x1F,0x08,0x1C,0x14,0x14,0x1F,0x0F,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x0F,0x1F,0x14,0x14,0x1F,0x0F,0x1C,0x14,0x14,0x1E,0x0E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x10,0x18,0x0C,0x06,0x07,0x0F,0x18,0x10,0x10,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x10,0x18,0x0C,0x07,0x1F,0x18,0x0C,0x06,0x0F,0x19,0x10,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x0C,0x1E,0x13,0x11,0x11,0x13,0x1E,0x0C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x01,0x21,0x31,0x19,0x0D,0x0F,0x1A,0x10,0x10,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x11,0x19,0x0D,0x1F,0x12,0x19,0x0D,0x1F,0x12,0x10,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x02,0x23,0x33,0x1B,0x1F,0x14,0x10,0x10,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x11,0x13,0x52,0x72,0x3E,0x1C,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x01,0x01,0x0F,0x1F,0x15,0x15,0x15,0x15,0x15,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x01,0x11,0x1F,0x1F,0x11,0x19,0x1D,0x15,0x01,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x12,0x3A,0x2F,0x27,0x37,0x1F,0x1E,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x02,0x02,0x06,0x24,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x01,0x01,0x11,0x1F,0x0E,0x02,0x26,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x0F,0x1F,0x10,0x10,0x18,0x0C,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x01,0x0D,0x1F,0x13,0x11,0x19,0x0D,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x01,0x0D,0x1F,0x13,0x1D,0x1F,0x13,0x19,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x09,0x1D,0x15,0x17,0x12,0x18,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x1F,0x1F,0x01,0x11,0x19,0x1F,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x1F,0x1F,0x08,0x1C,0x14,0x1F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x0F,0x1F,0x14,0x1F,0x1F,0x14,0x1F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x10,0x1C,0x0F,0x07,0x04,0x0C,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x08,0x0C,0x07,0x07,0x0C,0x0C,0x07,0x07,0x0C,0x08,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x0E,0x1E,0x13,0x11,0x1B,0x0E,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x01,0x11,0x19,0x0F,0x0E,0x18,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x19,0x1D,0x07,0x1F,0x19,0x0D,0x0F,0x1A,0x10,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x13,0x1B,0x0F,0x06,0x0C,0x18,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x08,0x09,0x09,0x09,0x0B,0x2A,0x3E,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x01,0x0D,0x1F,0x17,0x15,0x15,0x15,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x11,0x1F,0x1F,0x19,0x1D,0x15,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x0A,0x1E,0x17,0x17,0x1F,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x40,0x40,0x40,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x40,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x40,0x40,0x40,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x01,0x01,0x01},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x40,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x01,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x40,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x40,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x10,0x10,0x10,0x10,0x1F,0x1F,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF8,0xF8,0x40,0x40,0x40,
     0x00,0x00,0x0F,0x1F,0x10,0x10,0x18,0x08,0x0C,0x06,0x03,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xF0,0x40,0xF8,0xF8,0x00,
     0x00,0x00,0x0F,0x1F,0x10,0x18,0x08,0x0C,0x06,0x03,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF8,0xF8,0x00,0x00,0x00,
     0x00,0x00,0x0F,0x1F,0x10,0x10,0x18,0x08,0x0C,0x06,0x03,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x10,0x10,0x10,0x1F,0x1F,0x18,0x1F,0x17,0x10,0x10,0x10,0x10,0x00,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xF8,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x61,0x79,0x1F,0x06,0x04,0x04,0x04,0x7F,0x7F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x01,0x01,0x01,0x01,0x61,0x79,0x1F,0x06,0x04,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xF8,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x61,0x79,0x1F,0x06,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xF8,0x00,0x00,0x00,
     0x00,0x08,0x08,0x08,0x08,0x08,0x0C,0x04,0x04,0x04,0x04,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x40,0x40,0x40,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x40,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x40,0x40,0x40,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x01,0x01,0x01},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x40,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x01,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x40,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x40,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x1F,0x1F,0x10,0x10,0x10,0x10,0x10,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xF8,0xF8,0x40,0x40,0x40,
     0x00,0x00,0x0C,0x1F,0x13,0x18,0x08,0x0C,0x06,0x03,0x01,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xF0,0xF0,0x40,0xF8,0xF8,0x00,
     0x00,0x00,0x0C,0x1F,0x13,0x18,0x08,0x0C,0x06,0x03,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xF8,0xF8,0x00,0x00,0x00,
     0x00,0x00,0x0C,0x1F,0x13,0x18,0x08,0x0C,0x06,0x03,0x01,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x10,0x10,0x10,0x1F,0x1F,0x18,0x1F,0x17,0x10,0x10,0x10,0x10,0x00,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xF8,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x61,0x79,0x1F,0x06,0x04,0x04,0x04,0x7F,0x7F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x01,0x01,0x01,0x01,0x61,0x79,0x1F,0x06,0x04,0x3F,0x3F,0x00,0x7F,0x7F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xF8,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x61,0x79,0x1F,0x06,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x7F,0x7F,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0xF8,0x00,0x00,0x00,
     0x00,0x08,0x08,0x08,0x08,0x08,0x0C,0x04,0x04,0x04,0x04,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,0x10,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x50,0x50,0x50,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x50,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x50,0x50,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x50,0x50,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0xE0,0xE0,0x00,0x00,0x80,0x80,0xC0,0x60,0xFE,0xFE,0x10,0x10,0x10,
     0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xE0,0xE0,0x00,0x00,0x80,0x80,0xC0,0xFC,0xFC,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x03,0x03,0x00},
    {0x00,0x00,0x00,0xE0,0xE0,0x00,0x00,0x80,0x80,0xC0,0x60,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0xC0,0xC0,0x40,0x40,0x40,0x40,0x40,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x20,0x20,0x20,0x20,0x20,0xA0,0xE0,0x40,0x40,0x40,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00},
    {0x00,0x20,0x20,0x20,0x20,0x20,0xA0,0xE0,0x40,0x40,0xFE,0xFE,0x00,0xFF,0xFF,0x00,
     0x00,0x00,0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x03,0x03,0x00},
    {0x00,0x20,0x20,0x20,0x20,0x20,0xA0,0xE0,0x40,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00},
    {0x00,0x40,0x40,0x40,0x40,0x40,0xC0,0xC0,0x40,0xC0,0xC0,0x40,0x40,0x40,0x40,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,0x10,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x50,0x50,0x50,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0xFC,0x50,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x50,0x50,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x50,0x50,0xFC,0xFC,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x80,0xC0,0x40,0x00,0x00,0x00,0x80,0xC0,0x60,0xFE,0xFE,0x10,0x10,0x10,
     0x00,0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x01,0x00,0x00,0x03,0x03,0x00,0x00,0x00},
    {0x00,0x00,0x80,0xC0,0x40,0x00,0x00,0x00,0x80,0xC0,0xFC,0xFC,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x01,0x00,0x01,0x01,0x00,0x03,0x03,0x00},
    {0x00,0x00,0x80,0xC0,0x40,0x00,0x00,0x00,0x80,0xC0,0x60,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x01,0x00,0x00,0x03,0x03,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x40,0x40,0x40,0x40,0x40,0xC0,0x80,0x80,0x80,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x02,0x02,0x01,0x01,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00},
    {0x00,0x40,0x40,0x40,0x40,0x40,0x40,0xC0,0x80,0x80,0xFE,0xFE,0x00,0xFF,0xFF,0x00,
     0x00,0x00,0x00,0x00,0x02,0x02,0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x03,0x03,0x00},
    {0x00,0x40,0x40,0x40,0x40,0x40,0x40,0xC0,0x80,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x02,0x02,0x01,0x01,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00},
    {0x00,0x40,0x40,0x40,0x40,0x40,0xC0,0xC0,0x40,0xC0,0xC0,0x40,0x40,0x40,0x40,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x00,0x07,0x07,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0xC4,0xFC,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x44,0x64,0x3C,0x1C,0x04,0x44,0x7C,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x64,0x7C,0x18,0x60,0x7C,0x1C,0x70,0x60,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x1E,0x30,0x20,0x20,0x30,0x10,0x18,0x08},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x30,0x7C,0x4C,0x20,0x40,0x64,0x34,0x3C,0x68,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x30,0x78,0x4C,0x64,0x30,0x24,0x76,0x56,0x7E,0x3C,0x10,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x22,0x72,0x5A,0x4E,0x64,0x20,0x30,0x10},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x48,0x24,0x04,0x44,0x7C,0x38,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x44,0x64,0x7C,0x58,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x50,0x7C,0x3C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x28,0x60,0x70,0x1C,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x54,0x54,0x54,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x28,0x7C,0x7C,0x64,0x74,0x54,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x24,0x76,0x56,0x7E,0x3C,0x10,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x1C,0x3C,0x20,0x20,0x30,0x18,0x1C,0x3C,0x30,0x18,0x08},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x7E,0x50,0x38,0x68,0x7C,0x3C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x7C,0x7C,0x30,0x50,0x7C,0x7C,0x30,0x1C,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x1C,0x10,0x30,0x20,0x60,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x2C,0x38,0x18,0x0C,0x1C,0x30,0x20,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x64,0x44,0x64,0x3C,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x44,0x64,0x34,0x1C,0x38,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x45,0x65,0x37,0x1E,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x14,0x14,0xD4,0xFC,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x64,0x74,0x5C,0x4C,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x28,0x7A,0x5E,0x5C,0x5C,0x7C,0x30,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0xC4,0xFC,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x44,0x64,0x3C,0x1C,0x04,0x44,0x7C,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x64,0x7C,0x18,0x60,0x7C,0x1C,0x70,0x60,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x1E,0x30,0x20,0x20,0x30,0x10,0x18,0x08},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x30,0x7C,0x4C,0x20,0x40,0x64,0x34,0x3C,0x68,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x30,0x78,0x4C,0x64,0x30,0x24,0x76,0x56,0x7E,0x3C,0x10,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x22,0x72,0x5A,0x4E,0x64,0x20,0x30,0x10},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x4C,0x24,0x04,0x04,0x7C,0x38,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x44,0x64,0x7C,0x58,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x50,0x7C,0x3C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x28,0x60,0x70,0x1C,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x54,0x54,0x54,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x28,0x7C,0x7C,0x64,0x74,0x54,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x24,0x76,0x56,0x7E,0x3C,0x10,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x1C,0x3C,0x20,0x20,0x30,0x18,0x1C,0x3C,0x30,0x18,0x08},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x7E,0x50,0x38,0x68,0x7C,0x3C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x7C,0x7C,0x30,0x50,0x7C,0x7C,0x30,0x1C,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x1C,0x10,0x30,0x20,0x60,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x2C,0x38,0x18,0x0C,0x1C,0x30,0x20,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x64,0x44,0x64,0x3C,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x44,0x64,0x34,0x1C,0x38,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x45,0x65,0x37,0x1E,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x14,0x14,0xD4,0xFC,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x64,0x74,0x5C,0x4C,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x28,0x7A,0x5E,0x5C,0x5C,0x7C,0x30,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0xC4,0xFC,0x38,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x44,0x64,0x3C,0x1C,0x04,0x44,0x7C,0x38,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x64,0x7C,0x18,0x60,0x7C,0x1C,0x70,0x60},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x1E,0x30,0x20,0x20,0x30,0x10,0x18,0x08},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x30,0x7C,0x4C,0x20,0x40,0x64,0x34,0x3C,0x68,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x30,0x78,0x4C,0x64,0x30,0x24,0x76,0x56,0x7E,0x3C,0x10},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x22,0x72,0x5A,0x4E,0x64,0x20,0x30,0x10},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x4C,0x24,0x04,0x04,0x7C,0x38,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x44,0x64,0x7C,0x58},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x50,0x7C,0x3C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x28,0x60,0x70,0x1C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x54,0x54,0x54,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x28,0x7C,0x7C,0x64,0x74,0x54,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x24,0x76,0x56,0x7E,0x3C,0x10},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x1C,0x3C,0x20,0x20,0x30,0x18,0x1C,0x3C,0x30,0x18,0x08},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x7E,0x50,0x38,0x68,0x7C,0x3C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x30,0x50,0x7C,0x7C,0x30,0x1C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x1C,0x10,0x30,0x20,0x60,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x2C,0x38,0x18,0x0C,0x1C,0x30,0x20,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x64,0x44,0x64,0x3C,0x38,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x44,0x64,0x34,0x1C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x45,0x65,0x37,0x1E,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x14,0x14,0xD4,0xFC,0x38,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x64,0x74,0x5C,0x4C,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x28,0x7A,0x5E,0x5C,0x5C,0x7C,0x30,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x64,0x7C,0x18,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x44,0x64,0x3C,0x1C,0x04,0x44,0x7C,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x64,0x7C,0x18,0x60,0x78,0x1C,0x34,0x60,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x1E,0x3E,0x20,0x20,0x20,0x30,0x10,0x10,0x18,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x30,0x7C,0x4C,0x60,0x20,0x44,0x64,0x34,0x7C,0x48,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x30,0x7C,0x4C,0x40,0x20,0x68,0x7C,0x5C,0x7C,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x44,0x44,0x44,0x44,0x40,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x24,0x74,0x54,0x5C,0x68,0x20,0x30,0x10,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x20,0x74,0x54,0x5C,0x48,0x60,0x28,0x08,0x48,0x78,0x30,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x38,0x78,0x48,0x68,0x78,0x50,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x60,0x50,0x78,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x20,0x40,0x70,0x38,0x68,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x3C,0x7C,0x54,0x54,0x54,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x20,0x74,0x54,0x5C,0x48,0x20,0x78,0x78,0x48,0x78,0x70,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x20,0x74,0x54,0x5C,0x68,0x20,0x68,0x7C,0x5C,0x7C,0x38,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x1C,0x3C,0x20,0x20,0x30,0x18,0x3C,0x24,0x30,0x18,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x3C,0x7C,0x60,0x30,0x50,0x50,0x7C,0x3C,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x7C,0x7C,0x30,0x50,0x78,0x78,0x40,0x70,0x38,0x68,0x40,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x1C,0x10,0x30,0x20,0x60,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x40,0x60,0x30,0x1C,0x3C,0x60,0x60,0x38,0x1C,0x74,0x60,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x30,0x78,0x4C,0x44,0x4C,0x78,0x30,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x44,0x64,0x34,0x1C,0x38,0x60,0x40,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x45,0x65,0x37,0x1E,0x3C,0x60,0x40,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x20,0x24,0x24,0x24,0xAC,0xE8,0x78,0x30,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x3C,0x7C,0x54,0x54,0x54,0x54,0x54,0x40,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x44,0x7C,0x7C,0x44,0x64,0x74,0x54,0x04,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x08,0x28,0x7A,0x5A,0x4E,0x7C,0x38,0x00,0x00,0x00,0x00,0x00}
};
#endif

#ifdef KOR_FONT_HMGOTH
// 16x16 Korean font data (޸հü)
prog_uint8_t kor_font_hmgoth[360][32] = {          
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x82,0xC2,0x62,0x32,0x1E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x42,0x62,0x32,0x5E,0x6E,0x32,0x1E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xFE,0xFE,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xFE,0xFE,0x82,0x82,0x82,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x82,0xFE,0xFE,0x82,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7A,0x7A,0x4A,0x4A,0x4A,0x4E,0x4E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7E,0x7E,0x42,0x42,0x42,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7E,0x7E,0x48,0x48,0x48,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7E,0x5E,0x48,0x7E,0x5E,0x48,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x40,0x60,0x30,0x1E,0x1E,0x30,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x60,0x3E,0x5E,0x60,0x3E,0x1E,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3C,0x7E,0x42,0x42,0x7E,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x42,0x62,0x32,0x1E,0x1E,0x32,0x62,0x42,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x42,0x62,0x3E,0x5E,0x62,0x3E,0x1E,0x62,0x42,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x44,0x64,0x34,0x1E,0x1E,0x34,0x64,0x44,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x8A,0xCA,0x6A,0x3A,0x1E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7E,0x7E,0x4A,0x4A,0x4A,0x4A,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x42,0x7E,0x7E,0x42,0x42,0x7E,0x7E,0x42,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x3A,0x7E,0x47,0x47,0x7E,0x3A,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x3E,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x00,0x3E,0x3E,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x3E,0x3E,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x20,0x30,0x1E,0x1E,0x30,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x32,0x1A,0x0E,0x06,0x06,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x32,0x1A,0x2E,0x36,0x1A,0x0E,0x0E,0x32,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x24,0x34,0x1C,0x0C,0x06,0x06,0x0C,0x1C,0x34,0x24,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x22,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x1A,0x3E,0x26,0x27,0x27,0x26,0x3E,0x1A,0x02,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x3E,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x00,0x3E,0x3E,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x3E,0x3E,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x20,0x30,0x1E,0x1E,0x30,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x32,0x1A,0x0E,0x06,0x06,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x32,0x1A,0x2E,0x36,0x1A,0x0E,0x0E,0x32,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x24,0x34,0x1C,0x0C,0x06,0x06,0x0C,0x1C,0x34,0x24,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x22,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x1A,0x3E,0x26,0x27,0x27,0x26,0x3E,0x1A,0x02,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x02,0x3E,0x3E,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x2E,0x28,0x3E,0x2E,0x28,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x20,0x30,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x20,0x30,0x1E,0x2E,0x30,0x1E,0x0E,0x30,0x20,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x22,0x32,0x1A,0x0E,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x22,0x32,0x1E,0x2E,0x32,0x1E,0x0E,0x32,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x24,0x34,0x1C,0x0E,0x0E,0x1C,0x34,0x24,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x22,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x1A,0x3E,0x27,0x27,0x3E,0x1A,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x02,0x3E,0x3E,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x2E,0x28,0x3E,0x2E,0x28,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x20,0x30,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x20,0x30,0x1E,0x2E,0x30,0x1E,0x0E,0x30,0x20,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x22,0x32,0x1A,0x0E,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x22,0x32,0x1E,0x2E,0x32,0x1E,0x0E,0x32,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x24,0x34,0x1C,0x0E,0x0E,0x1C,0x34,0x24,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x22,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x1A,0x3E,0x27,0x27,0x3E,0x1A,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x82,0xC2,0x62,0x32,0x1E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x42,0x62,0x32,0x5E,0x6E,0x32,0x1E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x82,0x82,0x82,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0xFE,0xFE,0x82,0xFE,0xFE,0x82,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7A,0x7A,0x4A,0x4A,0x4E,0x4E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7E,0x7E,0x42,0x42,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7E,0x7E,0x48,0x48,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x7E,0x5E,0x48,0x7E,0x5E,0x48,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x40,0x60,0x30,0x1E,0x1E,0x30,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x40,0x60,0x3E,0x5E,0x60,0x3E,0x1E,0x60,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3C,0x7E,0x42,0x42,0x7E,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x42,0x62,0x32,0x1E,0x1E,0x32,0x62,0x42,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x42,0x62,0x3E,0x5E,0x62,0x3E,0x1E,0x62,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x44,0x64,0x34,0x1E,0x1E,0x34,0x64,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x8A,0xCA,0x6A,0x3A,0x1E,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x7E,0x7E,0x4A,0x4A,0x4A,0x4A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x42,0x7E,0x7E,0x42,0x7E,0x7E,0x42,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x3A,0x7E,0x47,0x47,0x7E,0x3A,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x02,0x02,0x3E,0x3E,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x00,0x3E,0x3E,0x22,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x28,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x28,0x28,0x3E,0x3E,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x20,0x30,0x1E,0x1E,0x30,0x30,0x1E,0x1E,0x30,0x20,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x1C,0x3E,0x22,0x22,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x32,0x1A,0x0E,0x06,0x06,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x32,0x1A,0x2E,0x36,0x1A,0x0E,0x0E,0x32,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x24,0x34,0x1C,0x0C,0x06,0x06,0x0C,0x1C,0x34,0x24,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x22,0x22,0x3E,0x3E,0x22,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x02,0x1A,0x3E,0x26,0x27,0x27,0x26,0x3E,0x1A,0x02,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x02,0x02,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x02,0x3E,0x3E,0x02,0x02,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x22,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x3A,0x3A,0x2A,0x2A,0x2A,0x2E,0x2E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x3E,0x3E,0x22,0x22,0x22,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x3E,0x3E,0x28,0x28,0x28,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x3E,0x2E,0x28,0x3E,0x2E,0x28,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x20,0x30,0x18,0x0E,0x0E,0x18,0x30,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x20,0x30,0x1E,0x2E,0x30,0x1E,0x0E,0x30,0x20,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x1C,0x3E,0x22,0x22,0x3E,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x22,0x32,0x1A,0x0E,0x0E,0x1A,0x32,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x22,0x32,0x1E,0x2E,0x32,0x1E,0x0E,0x32,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x24,0x34,0x1C,0x0E,0x0E,0x1C,0x34,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x3E,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x3E,0x3E,0x2A,0x2A,0x2A,0x2A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x22,0x3E,0x3E,0x22,0x3E,0x3E,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x02,0x1A,0x3E,0x27,0x27,0x3E,0x1A,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x20,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x48,0x48,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x90,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0x28,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0x28,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x04,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0xFE,0xFE,0x80,0x80,0x00,
     0x00,0x00,0x02,0x02,0x02,0x03,0x03,0x02,0x02,0x02,0x00,0x1F,0x1F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0xFE,0xFE,0x20,0xFE,0xFE,0x00,
     0x00,0x02,0x02,0x02,0x03,0x03,0x02,0x02,0x02,0x02,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x02,0x02,0x02,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x07,0x07,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x3F,0x3F,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00,0x04,0x04,0x04,0x3F,0x3F,0x00,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x04,0x04,0x04,0x1F,0x1F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x3F,0x3F,0x01,0x01,0x3F,0x3F,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x20,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x48,0x48,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x90,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0x28,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0x28,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x04,0x04,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0xFE,0xFE,0x80,0x80,0x00,
     0x00,0x00,0x02,0x02,0x02,0x03,0x03,0x02,0x02,0x02,0x00,0x1F,0x1F,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0xFE,0xFE,0x20,0xFE,0xFE,0x00,
     0x00,0x02,0x02,0x02,0x03,0x03,0x02,0x02,0x02,0x02,0x0F,0x0F,0x00,0x1F,0x1F,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x02,0x02,0x02,0x03,0x03,0x02,0x02,0x02,0x02,0x02,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x07,0x07,0x04,0x04,0x07,0x07,0x04,0x04,0x04,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x3F,0x3F,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00,0x04,0x04,0x04,0x3F,0x3F,0x00,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x04,0x04,0x04,0x1F,0x1F,0x00,0x3F,0x3F,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00,0x00,0x00,0x00,0x3F,0x3F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x3F,0x3F,0x01,0x01,0x3F,0x3F,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x28,0x28,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x50,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0x28,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x10,0x10,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x90,0x10,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x28,0x28,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x50,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0x28,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0x10,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0xFE,0xFE,0x10,0xFE,0xFE,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x10,0x10,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x90,0x10,0xFE,0xFE,0x00,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x02,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x7C,0x04,0x04,0x04,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x44,0x64,0x3C,0x3C,0x64,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x04,0x04,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x44,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x40,0x60,0x3C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x54,0x54,0x54,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x44,0x7C,0x44,0x7C,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x50,0x50,0x50,0x50,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x40,0x60,0x30,0x18,0x0C,0x0C,0x18,0x30,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x40,0x60,0x30,0x5C,0x7C,0x30,0x1C,0x1C,0x30,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x7C,0x38,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x18,0x18,0x38,0x28,0x48,0x48,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x1C,0x1C,0x38,0x28,0x48,0x48,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x54,0x54,0x54,0x54,0x54,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x28,0x78,0x5C,0x5C,0x5C,0x78,0x28,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x7C,0x04,0x04,0x04,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x44,0x64,0x3C,0x3C,0x64,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x04,0x04,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x44,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x40,0x60,0x3C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x54,0x54,0x54,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x44,0x7C,0x44,0x7C,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x50,0x50,0x50,0x50,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x40,0x60,0x30,0x18,0x0C,0x0C,0x18,0x30,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x40,0x60,0x30,0x5C,0x7C,0x30,0x1C,0x1C,0x30,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x7C,0x38,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x18,0x18,0x38,0x28,0x48,0x48,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x1C,0x1C,0x38,0x28,0x48,0x48,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x54,0x54,0x54,0x54,0x54,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x28,0x78,0x5C,0x5C,0x5C,0x78,0x28,0x08,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x7C,0x7C,0x04,0x04,0x04,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x44,0x64,0x3C,0x3C,0x64,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x40,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x04,0x04,0x04,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x44,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x40,0x60,0x3C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x54,0x54,0x54,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x44,0x7C,0x44,0x7C,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x28,0x78,0x5C,0x5C,0x78,0x28},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x50,0x50,0x50,0x50,0x50,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x40,0x60,0x30,0x18,0x0C,0x0C,0x18,0x30,0x60,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x40,0x60,0x30,0x5C,0x7C,0x30,0x1C,0x1C,0x30,0x60,0x40},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x7C,0x38,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x18,0x18,0x38,0x28,0x48,0x48,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x48,0x48,0x28,0x38,0x1C,0x1C,0x38,0x28,0x48,0x48,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x7C,0x7C,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x44,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x28,0x78,0x5C,0x5C,0x5C,0x5C,0x78,0x28,0x08},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x7C,0x04,0x04,0x04,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x04,0x04,0x04,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x40,0x44,0x64,0x3C,0x3C,0x64,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x7C,0x7C,0x40,0x40,0x40,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x74,0x74,0x54,0x54,0x54,0x54,0x54,0x54,0x5C,0x5C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x04,0x04,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x44,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x40,0x60,0x3C,0x3C,0x60,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x7C,0x7C,0x54,0x54,0x54,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x00,0x44,0x7C,0x44,0x7C,0x44,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x74,0x74,0x54,0x5C,0x5C,0x28,0x78,0x5C,0x5C,0x78,0x28,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x7C,0x7C,0x44,0x44,0x44,0x44,0x44,0x44,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x7C,0x7C,0x50,0x50,0x50,0x50,0x50,0x50,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x7C,0x7C,0x50,0x7C,0x7C,0x40,0x60,0x3C,0x3C,0x60,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x40,0x60,0x30,0x18,0x0C,0x0C,0x18,0x30,0x60,0x40,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x40,0x60,0x30,0x5C,0x7C,0x30,0x1C,0x1C,0x30,0x60,0x40,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x38,0x7C,0x44,0x44,0x44,0x44,0x7C,0x38,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x48,0x68,0x38,0x18,0x08,0x08,0x18,0x38,0x68,0x48,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x48,0x68,0x38,0x18,0x0C,0x0C,0x18,0x38,0x68,0x48,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x7C,0x7C,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x7C,0x7C,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x44,0x44,0x7C,0x7C,0x44,0x44,0x7C,0x7C,0x44,0x44,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x08,0x28,0x78,0x5C,0x5C,0x5C,0x5C,0x78,0x28,0x08,0x00,0x00,0x00}
};
#endif
#endif
#endif

